% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/postprocessing.R
\name{reconstruct.bs}
\alias{reconstruct.bs}
\title{reconstruct.bs function}
\usage{
reconstruct.bs(mod, varname, probs = c(0.025, 0.975), bw = FALSE,
  xlab = NULL, ylab = NULL, plot = TRUE, ...)
}
\arguments{
\item{mod}{model output, created by function survspat}

\item{varname}{name of the variable modelled by a B-spline}

\item{probs}{upper and lower quantiles for confidence regions to plot> The default is c(0.025,0.975).}

\item{bw}{Logical. Plot in black/white/greyscale? Default is to produce a colour plot. Useful for producing plots for journals that do not accept colour plots.}

\item{xlab}{label for x axis, there is a sensible default}

\item{ylab}{label for y axis, there is a sensible default}

\item{plot}{logical, whether to plot the effect of varname over time}

\item{...}{other arguments to be passed to the plotting function.}
}
\value{
median, upper and lower confidence bands for the effect of varname over time; the funciton also produces a plot.
}
\description{
When bs(varname) has been used in the formula of a model, this function can be used to reconstruct the posterior relative risk of
that parameter over time.
}

