\name{lpp}
\alias{lpp}
\title{
  Create Point Pattern on Linear Network
}
\description{
  Creates an object of class \code{"lpp"} that represents
  a point pattern on a linear network.
}
\usage{
lpp(X, L, \dots)
}
\arguments{
  \item{X}{
    Locations of the points. A matrix or data frame of coordinates,
    or a point pattern object (of class
    \code{"ppp"}) or other data acceptable to \code{\link{as.ppp}}.
  }
  \item{L}{
    Linear network (object of class \code{"linnet"}).
  }
  \item{\dots}{
    Ignored.
  }
}
\details{
  This command creates an object of class \code{"lpp"} that represents
  a point pattern on a linear network.

  Normally \code{X} is a point pattern. The points of \code{X} should lie
  on the lines of \code{L}.

  Alternatively \code{X} may be a matrix or data frame containing at
  least two columns.
  \itemize{
    \item Usually
    the first two columns of \code{X} will be interpreted
    as spatial coordinates, and any remaining columns as marks.
    \item 
    The exception occurs if \code{X} is a data frame with columns named
    \code{x}, \code{y}, \code{seg} and \code{tp}. Then
    \code{x} and \code{y} will be interpreted as spatial
    coordinates, and \code{seg} and \code{tp} as local
    coordinates, with \code{seg} indicating which line segment of
    \code{L} the point lies on, and \code{tp} indicating how far along
    the segment the point lies (normalised to 1). Any remaining columns
    will be interpreted as marks.
  }
}
\section{Note on changed format}{
  The internal format of \code{"lpp"} objects was changed in
  \pkg{spatstat} version \code{1.28-0}.
  Objects in the old format are still handled correctly,
  but computations are faster in the new format.
  To convert an object \code{X} from the old format to the new format,
  use \code{X <- lpp(as.ppp(X), as.linnet(X))}.
}
\value{
  An object of class \code{"lpp"}. 
  Also inherits the class \code{"ppx"}.
}
\author{
  Ang Qi Wei \email{aqw07398@hotmail.com} and
  Adrian Baddeley \email{Adrian.Baddeley@uwa.edu.au}
  \url{http://www.maths.uwa.edu.au/~adrian/}
}
\seealso{
  Installed datasets which are \code{"lpp"} objects:
  \code{\link{chicago}}, \code{\link{dendrite}}, \code{\link{spiders}}.
  
  See \code{\link{as.lpp}} for converting data to an \code{lpp} object.

  See \code{\link{methods.lpp}} and
  \code{\link{methods.ppx}} for other methods applicable
  to \code{lpp} objects.

  Calculations on an \code{lpp} object:
  \code{\link{intensity.lpp}},
  \code{\link{distfun.lpp}},
  \code{\link{nndist.lpp}},
  \code{\link{nnwhich.lpp}},
  \code{\link{nncross.lpp}},
  \code{\link{nnfun.lpp}}.

  Summary functions: 
  \code{\link{linearK}},
  \code{\link{linearKinhom}},
  \code{\link{linearpcf}},
  \code{\link{linearKdot}},
  \code{\link{linearKcross}},
  \code{\link{linearmarkconnect}}, etc.
  
  Random point patterns on a linear network can be generated by
  \code{\link{rpoislpp}} or \code{\link{runiflpp}}.

  See \code{\link{linnet}} for linear networks.
}
\examples{
  example(linnet)
  xx <- list(x=c(-1.5,0,0.5,1.5), y=c(1.5,3,4.5,1.5))
  X <- lpp(xx, letterA)
  plot(X)
  X
  summary(X)
}
\keyword{spatial}
