% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicator_psdtype.R
\name{indicator_psdtype}
\alias{indicator_psdtype}
\title{Change in patch-size distributions types}
\usage{
indicator_psdtype(
  x,
  xmin = 1,
  merge = FALSE,
  fit_lnorm = FALSE,
  xmin_bounds = NULL,
  best_by = "AIC",
  wrap = FALSE
)
}
\arguments{
\item{x}{A logical (TRUE/FALSE values) matrix or a list of these.}

\item{xmin}{The xmin to be used to fit the patch size distributions. Use 
the special values "estimate" to use an estimated xmin for each fit}

\item{merge}{The default behavior is to produce indicators values for each 
matrix. If this parameter is set to TRUE then the patch size distributions 
are pooled together for fitting.}

\item{fit_lnorm}{Fit also a log-normal distribution}

\item{xmin_bounds}{Restrict the possible xmins in this range (defaults to 
the whole range of observed patch sizes)}

\item{best_by}{The criterion used to select the best distribution type 
(one of \code{"AIC"}, \code{"BIC"} or \code{"AICc"}).}

\item{wrap}{Determines whether patches are considered to wrap around the 
matrix when reaching the side}
}
\value{
A data.frame (or a list of these if x is a list) with the 
  following columns:
    \itemize{
      \item `method` the method used for fitting (currently: only 
         log-likelihood is implemented, "ll")
      \item `type` the type of distribution fit
      \item `npars` the number of parameters of the distribution type
      \item `AIC`, `AICc` and `BIC` the values for Akaike Information 
        Criterion (or the corrected for small samples equivalent AICc), 
        and Bayesion Information Criterion (BIC)
      \item `best` A logical vector indicating which distribution is the 
        best fit 
      \item `expo`, `rate`, `meanlog`, `sdlog` the estimates for distribution
        parameters. 
      \item 'percolation' A logical value indicating whether there is 
        \code{\link{percolation}} in the system. 
    }
}
\description{
This functions fits different patch size distributions 
 types (power-law, log-normal, exponential and truncated power-law) to 
 the patches contained in a matrix. The distributions are returned with 
 their corresponding AIC, BIC and AICc to select the best fit.
}
\details{
Patterned ecosystems can exhibit a change in their spatial structure as they 
become more and more stressed. It has been suggested that this should be 
reflected in changes in the observed patch size distributions (PSD). 
The following sequence is expected to occur (Kefi et al. 2011) as patterned 
ecosystems become more and more degraded:

  - Percolation of vegetation patches occurs (a patch has a width or height 
  equal to the size of the system)
  
  - The patch-size distribution follows a power-law
  
  - The patch-size distribution deviates from a power-law as larger patches 
  break down
  
  - The patch-size distribution is closer to an exponential 
  distribution

This indicator fits the observed patch size distribution based on 
maximum-likelihood (following Clauset et al. 2009 recommendations), then 
select the best model using AIC, BIC (default) or AICc.
}
\examples{

data(forestgap)

# One logical matrix only
indicator_psdtype(forestgap[[1]])

# A list of these matrices
\dontrun{ 
indicator_psdtype(forestgap)
}

}
\references{
Kefi, S., Rietkerk, M., Roy, M., Franc, A., de Ruiter, P.C. & Pascual, M.
(2011). Robust scaling in ecosystems and the meltdown of patch size
distributions before extinction: Patch size distributions towards 
extinction. Ecology Letters, 14, 29-35.

Kefi, S., Rietkerk, M., Alados, C.L., Pueyo, Y., Papanastasis, V.P., ElAich,
A., et al. (2007). Spatial vegetation patterns and imminent desertification
in Mediterranean arid ecosystems. Nature, 449, 213-217.

Clauset, A., Shalizi, C. R., & Newman, M. E. (2009). 
  Power-law distributions in empirical data. SIAM review, 51(4), 661-703.
}
\seealso{
\code{\link{patchdistr_sews}}

\code{\link{patchdistr_sews}}
}
