% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpson.R
\name{simpsonF}
\alias{simpsonF}
\alias{simpson.index}
\alias{simpson.index}
\title{Spatial Simpson index}
\usage{
simpsonF(X, r = NULL, ...)

simpson.index(X, spatial = FALSE, ...)
}
\arguments{
\item{X}{Multitype point pattern of class \code{ppp} (see package 'spatstat')}

\item{r}{Vector of sizes for neighbourhoods, e.g. \code{geometric} graph with different ranges.}

\item{...}{Further parametes for the function \code{\link{segregationFun}}.}

\item{spatial}{If FALSE, return the classical aspatial index value.}
}
\value{
If spatial, returns an \code{fv}-object, see \code{spatstat} for more information. Otherwise a numeric value.
}
\description{
Compute the spatial and non-spatial Simpson index for a given multitype point pattern.
}
\details{
The form of Simpson index is  \var{S = 1 - sum pi_tau}, where the sum is over the types of the pattern, and \var{pi_tau} is like
in Shimatani\& Kubota 2004.
The function \code{simpsonF} is the main calculation function. Uses function \code{\link{segregationFun}}.

The function \code{simpson.index} is a shortcut to get a single value for the pattern using 4-nearest neighbours graph by default.
}
\section{Functions}{
\itemize{
\item \code{simpson.index}: The Spatial Simpson Index
}}

\references{
Rajala, Illian: A family of spatial biodiversity measures based on graphs, Env. Ecol. Stat. 2012

Shimatani, Kubota: Quantitative assesment of multispecies spatial pattern with high species diversity. Ecological Research, 19, 2004.
}
