% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highest_concentration_terra.R
\name{find_highest_concentration}
\alias{find_highest_concentration}
\title{Find highest concentration}
\usage{
find_highest_concentration(
  df,
  value,
  top_n = 1,
  radius = 200,
  cell_size = 100,
  grid_precision = 1,
  lon = "lon",
  lat = "lat",
  crs_metric = 3035,
  print_progress = TRUE
)
}
\arguments{
\item{df}{data.frame. Should include at least columns for longitude,
latitude, and the value of interest to summarize.}

\item{value}{column name with value of interest to summarize in \code{df}.}

\item{top_n}{positive integer value greater or equal to 1 (default is 1).}

\item{radius}{numeric. Radius of the circle in meters (default is 200).}

\item{cell_size}{numeric. Size of cell in meters (default is 100).}

\item{grid_precision}{numeric. Precision of grid in meters (default is 1).}

\item{lon}{column name in \code{df} with longitude (default is "lon").
Should be in   EPSG:4326.}

\item{lat}{column name in \code{df} with latitude (default is "lat").
Should be in EPSG:4326.}

\item{crs_metric}{numeric. The metric Coordinate Reference System (CRS) is
used solely in the background calculations. For European coordinates,
\href{https://epsg.io/3035}{EPSG:3035} (default) is recommended. For the
United States, \href{https://epsg.io/6317}{EPSG:6317} can be utilized. For
Asia and the Pacific regions, \href{https://epsg.io/8859}{EPSG:8859} is
recommended.}

\item{print_progress}{print progress iteration steps.}
}
\value{
A list with two elements:
\enumerate{
\item A data.frame containing the \code{top_n} concentrations as specified
by \code{top_n}.
\item A data.frame containing the rows from \code{df} that correspond to the
\code{top_n} concentrations.
}
}
\description{
Determines the central coordinates of a circle with a constant
radius that maximizes the coverage of demand points.
}
\details{
A recent regulation by the European Commission mandates insurance
companies to report the maximum value of insured fire risk policies for all
buildings partially or fully situated within a circle with a radius of 200
meters  (see Article 132 - fire risk sub-module - of the Delegated
Regulation). This article captures the risk of catastrophic fire or
explosion, including as a result of terrorist attacks. The sub-module is
based on the scenario that the insurance or reinsurance undertaking incurs a
loss equal to the capital insured for each building located partly or fully
within a radius of 200 meters.

This problem resembles a Maximal Covering Location Problem (MCLP)
with a fixed radius, belonging to the category of facility location problems.
The main aim is to select the best locations for a predetermined number of
facilities to achieve maximum coverage of demand points within a specified
radius of each facility. In essence, the objective is to identify optimal
facility locations to cover as many demand points as feasible, while ensuring
that each demand point falls within the designated distance (radius) of at
least one facility.
}
\examples{
x <- find_highest_concentration(Groningen, "amount")
plot(x)

y <- find_highest_concentration(
    Groningen, "amount", top_n = 2, cell_size = 50
)
plot(y)

}
\references{
Commission Delegated Regulation (EU) (2015). Solvency II
Delegated Act 2015/35. Official Journal of the European Union, 58:124.
}
\author{
Martin Haringa
}
