% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ripleys_k.R
\name{NN_G}
\alias{NN_G}
\title{Nearest Neighbor Based Measures of Spatial Clustering for IF data}
\usage{
NN_G(
  mif,
  mnames,
  r_range = seq(0, 100, 50),
  num_permutations = 50,
  edge_correction = "rs",
  keep_perm_dis = FALSE,
  workers = 1,
  overwrite = FALSE
)
}
\arguments{
\item{mif}{An MIF object}

\item{mnames}{Character vector of marker names to estimate degree of
nearest neighbor distribution}

\item{r_range}{Numeric vector of potential r values this range must include 0.}

\item{num_permutations}{Numeric value indicating the number of permutations used.
Default is 50.}

\item{edge_correction}{Character value indicating the type of edge correction
to use. Options include "rs" or "hans".}

\item{keep_perm_dis}{Logical value determining whether or not to keep the full
distribution of permuted G values}

\item{workers}{Integer value for the number of workers to spawn}

\item{overwrite}{Logical value determining if you want the results to replace the
current output (TRUE) or be to be appended (FALSE).}
}
\value{
Returns a data.frame
\item{Theoretical CSR}{Expected value assuming complete spatial randomnessn}
\item{Permuted CSR}{Average observed G for the permuted point
process}
\item{Observed}{Observed valuefor the observed point process}
\item{Degree of Clustering Permuted}{Degree of spatial clustering where the
reference is the permuted estimate of CSR}
\item{Degree of Clustering Theoretical}{Degree of spatial clustering where the
reference is the theoretical estimate of CSR}
}
\description{
For a given cell type, this function computes proportion of cells
that have nearest neighbor less than r for the observed and permuted point processes.
}
