% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STdiff.R
\name{STdiff}
\alias{STdiff}
\title{STdiff: Differential gene expression analysis for spatial transcriptomics data}
\usage{
STdiff(
  x = NULL,
  samples = NULL,
  annot = NULL,
  w = NULL,
  k = NULL,
  deepSplit = NULL,
  topgenes = 5000,
  pval_thr = 0.05,
  pval_adj = "fdr",
  test_type = "mm",
  sp_topgenes = 0.2,
  clusters = NULL,
  pairwise = FALSE,
  verbose = 1L,
  cores = NULL
)
}
\arguments{
\item{x}{an STlist}

\item{samples}{an integer indicating the spatial samples to be included in the DE tests.
Numbers follow the order in \code{names(x@counts)}. Sample names are also allowed.
If NULL, performs tests on all samples}

\item{annot}{a column name in \code{x@spatial_meta} containing the groups/clusters to
be tested. Required if \code{k} and \code{w} are empty.}

\item{w}{the spatial weight used in STclust. Required if \code{annot} is empty.}

\item{k}{the k value used in STclust, or \code{dtc} for dynamicTreeCut clusters. Required if \code{annot} is empty.}

\item{deepSplit}{the deepSplit value if used in STclust. Required if \code{k='dtc'}.}

\item{topgenes}{an integer indicating the top variable genes to select from each sample
based on variance (default=5000). If NULL, all genes are selected.}

\item{pval_thr}{cut-off of adjusted p-values to define differentially expressed genes from
non-spatial linear models. A proportion of genes (\code{sp_topgenes}) under this cut-off
will be applied the spatial models. Default=0.05}

\item{pval_adj}{Method to adjust p-values. Defaults to \code{FDR}. Other options as
available from \code{p.adjust}}

\item{test_type}{one of \code{mm}, \code{t_test}, or \code{wilcoxon}. Specifies the type of
test performed.}

\item{sp_topgenes}{Proportion of differentially expressed genes from non-spatial
linear models (and controlled by \code{pval_thr}) to use in differential gene expression
analysis with spatial linear models. If 0 (zero), no spatial models are fit. Default=0.2}

\item{clusters}{cluster name(s) to test DE genes, as opposed to all clusters.}

\item{pairwise}{whether or not to carry tests on a pairwise manner. The default is
\code{pairwise=F}, meaning that DE genes are tested by comparing each cluster to the
rest of the pooled cell/spots.}

\item{verbose}{either logical or an integer (0, 1, or 2) to increase verbosity}

\item{cores}{Number of cores to use in parallelization. If \code{NULL}, the number of
cores to use is detected automatically}
}
\value{
a list with one data frame per sample with results of differential gene
expression analysis
}
\description{
Tests for differentially expressed genes using linear models with or
without spatial covariance structures
}
\details{
The method tests for differentially expressed genes between groups of spots/cells
(e.g., clusters) in a spatial transcriptomics sample. Specifically, the function
tests for genes with significantly higher or lower gene expression in one group of
spots/cells with respect to the rest of spots/cells in the sample. The method first
runs non-spatial linear models on the genes to detect differentially expressed genes.
Then spatial linear models with exponential covariance structure are fit on a
subset of genes detected as differentially expressed by the non-linear models (\code{sp_topgenes}).
If running on clusters detected via STclust, the user can specify the assignments
using the same parameters (\code{w}, \code{k}, \code{deepSplit}). Otherwise, the assignments are
specified by indicating one of the column names in \code{x@spatial_meta}. The function
uses \code{spaMM::fitme} and is computationally expensive even on HPC environments.
To run the STdiff using the non-spatial approach (faster), set \code{sp_topgenes=0}.
}
