% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster.mds.R
\name{raster.mds}
\alias{raster.mds}
\title{Raster multidimensional scaling (MDS)}
\usage{
raster.mds(r, s = 5, window.median = FALSE, ...)
}
\arguments{
\item{r}{A terra SpatRaster class object}

\item{s}{Window size (may be a vector of 1 or 2) of 
n x n dimension.}

\item{window.median}{(FALSE/TRUE) Return the median of the MDS 
matrix values.}

\item{...}{Additional arguments passed to terra::focal}
}
\value{
A terra SpatRaster class object
}
\description{
Multidimensional scaling of raster values within an N x N focal window
}
\details{
An MDS focal function. If only one value provided for s, then a square matrix 
(window) will be used. If window.median = FALSE then the center value of the 
matrix is returned and not the median of the matrix
}
\examples{
\donttest{ 
 library(terra)
 r <- rast(system.file("ex/elev.tif", package="terra"))
   r <- r[[1]] / max(global(r, "max", na.rm=TRUE)[,1])
 
 diss <- raster.mds(r)
 diss.med <- raster.mds(r, window.median = TRUE)

opar <- par(no.readonly=TRUE)
   par(mfrow=c(2,2))
   plot(r)
     title("Elevation")
   plot( focal(r, w = matrix(1, nrow=5, ncol=5), fun = var) )
     title("Variance")		 
     plot(diss)
       title("MDS")
     plot(diss.med)
       title("Median MDS")
par(opar)
}

}
\references{
Quinn, G.P., & M.J. Keough (2002) Experimental design and data analysis 
  for biologists. Cambridge University Press. Ch. 18. Multidimensional 
  scaling and cluster analysis.
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
