% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nni.R
\name{nni}
\alias{nni}
\title{Average Nearest Neighbour Index (NNI)}
\usage{
nni(x, win = "hull")
}
\arguments{
\item{x}{An sp point object}

\item{win}{Type of window 'hull' or 'extent'}
}
\value{
list object containing NNI = nearest neighbor index, z.score = Z Score value, p = p value, expected.mean.distance = Expected meand distance, observed.mean.distance = Observed meand distance.
}
\description{
Calculates the NNI as a measure of clustering or dispersal
}
\note{
The nearest neighbour index is expressed as the ratio of the observed distance divided by the expected distance. The expected distance is the average distance between neighbours in a hypothetical random distribution. If the index is less than 1, the pattern exhibits clustering; if the index is greater than 1, the trend is toward dispersion or competition.
The Nearest Neighbour Index is calculated as:
  Mean Nearest Neighbour Distance (observed) D(nn) = sum(min(Dij)/N) 
  Mean Random Distance (expected) D(e) = 0.5 SQRT(A/N)
  Nearest Neighbour Index NNI = D(nn)/D(e)
      Where; D=neighbour distance, A=Area

Depends: sp, spatstat
}
\examples{
require(sp)
data(meuse)
  coordinates(meuse) <- ~x+y
    nni(meuse)

}
\references{
Clark, P.J., and F.C. Evans (1954) Distance to nearest neighbour as a measure of spatial relationships in populations. Ecology 35:445-453

Cressie, N (1991) Statistics for spatial data. Wiley & Sons, New York.
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
