% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasterCorrelation.R
\name{rasterCorrelation}
\alias{rasterCorrelation}
\title{Raster correlation}
\usage{
rasterCorrelation(x, y, s = 3, type = "pearson", file.name = NULL, ...)
}
\arguments{
\item{x}{raster class object for x}

\item{y}{raster class object for y}

\item{s}{Scale of window. Can be a single value, two values for uneven window or a custom matrix. Must be odd number (eg., s=3, for 3x3 window or s=c(3,5) for 3 x 5 window)}

\item{type}{Type of output, options are: "pearson", "spearman", "covariance"}

\item{file.name}{Name of output raster (optional)}

\item{...}{Additional arguments passed to writeRaster}
}
\value{
raster class object or raster written to disk
}
\description{
Performs a simple moving window correlation between two rasters
}
\note{
Depends: raster
}
\examples{
 library(raster)                                                                    
 b <- brick(system.file("external/rlogo.grd", package="raster"))
 x <- b[[1]]
 y <- b[[3]]
 r.cor <- rasterCorrelation(x, y, s = 5, type = "spearman")
 plot(r.cor)

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
