% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustness_analysis.R
\name{oat_csv_result_file_analysis}
\alias{oat_csv_result_file_analysis}
\title{Performs a robustness analysis for supplied simulation data, comparing simulation behaviour at different parameter values}
\usage{
oat_csv_result_file_analysis(FILEPATH, CSV_FILE_NAME, PARAMETERS, BASELINE,
  MEASURES, ATESTRESULTFILENAME, PMIN = NULL, PMAX = NULL, PINC = NULL,
  PARAMVALS = NULL, TIMEPOINTS = NULL, TIMEPOINTSCALE = NULL,
  check_done = FALSE)
}
\arguments{
\item{FILEPATH}{Directory where either the simulation runs or single CSV file result can be found}

\item{CSV_FILE_NAME}{Name of the CSV file in which the results of all simulations exist (or have been summarised)}

\item{PARAMETERS}{Array containing the names of the parameters for which local analyses are being conducted}

\item{BASELINE}{Array containing the values assigned to each of these parameters in the calibrated baseline}

\item{MEASURES}{Array containing the names of the output measures which are used to analyse the simulation}

\item{ATESTRESULTFILENAME}{File name of the ATests result summary file that will be created For one timepoint, this could be ATests.csv. For additional timepoints, the time is added to the file name}

\item{PMIN}{Array containing the minimum value that should be used for each parameter.  Sets a lower bound on sampling space}

\item{PMAX}{Array containing the maximum value that should be used for each parameter.  Sets an upper bound on sampling space}

\item{PINC}{Array containing the minimum value that should be used for each parameter.  Sets a lower bound on sampling space}

\item{PARAMVALS}{Array containing a list of strings for each parameter, each string containing comma separated values that should be assigned to that parameter. Thus sampling can be performed for specific values for each parameter, rather than a uniform incremented value. This replaces the PMIN, PMAX, and PINC where this method is used}

\item{TIMEPOINTS}{Implemented so this method can be used when analysing multiple simulation timepoints. If only analysing one timepoint, this should be set to NULL. If not, this should be an array of timepoints, e.g. c(12,36,48,60)}

\item{TIMEPOINTSCALE}{Implemented so this method can be used when analysing multiple simulation timepoints. Sets the scale of the timepoints being analysed, e.g. "Hours"}

\item{check_done}{Whether the input has been checked (used when doing multiple timepoints)}
}
\description{
This method takes either the CSV file created in
\code{oat_processParamSubsets} or provided by the user and analyses the
impact that a change in a single parameter value has had on simulation
response. This is performed by comparing the distribution of responses
for a perturbed parameter condition with the distribution under
baseline/calibrated conditions. This produces a CSV file, in the directory
stated in FILEPATH, named as stated by parameter ATESTRESULTSFILENAME,
containing the A-Test scores for all parameter conditions under which the
simulation was run. This method can be performed for a number of simulation
timepoints, producing these statistics for each timepoint taken.
}
