% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coerce.R
\name{coerce_to_sparse_data_frame}
\alias{coerce_to_sparse_data_frame}
\title{Coerce sparse matrix to data frame with sparse columns}
\usage{
coerce_to_sparse_data_frame(x, call = rlang::caller_env(0))
}
\arguments{
\item{x}{sparse matrix.}

\item{call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
data.frame with sparse columns
}
\description{
Turning a sparse matrix into a data frame
}
\details{
The only requirement from the sparse matrix is that it contains column names.
}
\examples{
\dontshow{if (rlang::is_installed("Matrix")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set.seed(1234)
mat <- matrix(sample(0:1, 100, TRUE, c(0.9, 0.1)), nrow = 10)
colnames(mat) <- letters[1:10]
sparse_mat <- Matrix::Matrix(mat, sparse = TRUE)
sparse_mat

res <- coerce_to_sparse_data_frame(sparse_mat)
res

# All columns are sparse
vapply(res, is_sparse_vector, logical(1))
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=coerce_to_sparse_tibble]{coerce_to_sparse_tibble()}} \code{\link[=coerce_to_sparse_matrix]{coerce_to_sparse_matrix()}}
}
