% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stein-shrinkage.r
\name{var_shrinkage}
\alias{var_shrinkage}
\title{Shrinkage-based estimator of variances for each feature from Pang et al.
(2009).}
\usage{
var_shrinkage(N, K, var_feature, num_alphas = 101, t = -1)
}
\arguments{
\item{N}{the sample size.}

\item{K}{the number of classes.}

\item{var_feature}{a vector of the sample variances for each feature.}

\item{num_alphas}{The number of values used to find the optimal amount of
shrinkage.}

\item{t}{a constant specified by the user that indicates the exponent to use
with the variance estimator. By default, t = -1 as in Pang et al. See the
paper for more details.}
}
\value{
a vector of the shrunken variances for each feature.
}
\description{
This function computes the shrinkage-based estimator of variance of each
feature (variable) from Pang et al. (2009) for the SDLDA classifier.
}
\references{
Pang, H., Tong, T., & Zhao, H. (2009). "Shrinkage-based Diagonal
Discriminant Analysis and Its Applications in High-Dimensional Data,"
Biometrics, 65, 4, 1021-1029.
\url{http://onlinelibrary.wiley.com/doi/10.1111/j.1541-0420.2009.01200.x/abstract}
}

