% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdf_interface.R
\name{sdf_register}
\alias{sdf_register}
\title{Register a Spark DataFrame}
\usage{
sdf_register(x, name = NULL)
}
\arguments{
\item{x}{A Spark DataFrame.}

\item{name}{A name to assign this table.}
}
\description{
Registers a Spark DataFrame (giving it a table name for the
Spark SQL context), and returns a \code{tbl_spark}.
}
\section{Transforming Spark DataFrames}{


The family of functions prefixed with \code{sdf_} generally access the Scala
Spark DataFrame API directly, as opposed to the \code{dplyr} interface which
uses Spark SQL. These functions will 'force' any pending SQL in a
\code{dplyr} pipeline, such that the resulting \code{tbl_spark} object
returned will no longer have the attached 'lazy' SQL operations. Note that
the underlying Spark DataFrame \emph{does} execute its operations lazily, so
that even though the pending set of operations (currently) are not exposed at
the \R level, these operations will only be executed when you explicitly
\code{collect()} the table.
}

\seealso{
Other Spark data frames: \code{\link{sdf_copy_to}},
  \code{\link{sdf_partition}}, \code{\link{sdf_sample}},
  \code{\link{sdf_sort}}
}
