% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizers.R
\name{summarize_geometric_mean}
\alias{summarize_geometric_mean}
\title{Geometric mean summarizer}
\usage{
summarize_geometric_mean(
  ts_rdd,
  column,
  key_columns = list(),
  incremental = FALSE
)
}
\arguments{
\item{ts_rdd}{Timeseries RDD being summarized}

\item{column}{Column to be summarized}

\item{key_columns}{Optional list of columns that will form an equivalence
relation associating each record with the time series it belongs to (i.e.,
any 2 records having equal values in those columns will be associated with
the same time series, and any 2 records having differing values in those
columns are considered to be from 2 separate time series and will therefore
be summarized separately)
By default, `key_colums` is empty and all records are considered to be part
of a single time series.}

\item{incremental}{If FALSE and `key_columns` is empty, then apply the
summarizer to all records of `ts_rdd`.
If FALSE and `key_columns` is non-empty, then apply the summarizer to all
records within each group determined by `key_columns`.
If TRUE and `key_columns` is empty, then for each record in `ts_rdd`,
the summarizer is applied to that record and all records preceding it, and
the summarized result is associated with the timestamp of that record.
If TRUE and `key_columns` is non-empty, then for each record within a group
of records determined by 1 or more key columns, the summarizer is applied
to that record and all records preceding it within its group, and the
summarized result is associated with the timestamp of that record.}
}
\value{
A TimeSeriesRDD containing the summarized result
}
\description{
Compute geometric mean of values from `column` within a moving time window or
within each group of records with identical timestamps and store results in a
new column named `<column>_geometricMean`
}
\examples{

library(sparklyr)
library(sparklyr.flint)

sc <- try_spark_connect(master = "local")

if (!is.null(sc)) {
  sdf <- copy_to(sc, tibble::tibble(t = seq(10), u = seq(10, 1, -1)))
  ts <- fromSDF(sdf, is_sorted = TRUE, time_unit = "SECONDS", time_column = "t")
  ts_geometric_mean <- summarize_geometric_mean(ts, column = "u")
} else {
  message("Unable to establish a Spark connection!")
}

}
\seealso{
Other summarizers: 
\code{\link{ols_regression}()},
\code{\link{summarize_avg}()},
\code{\link{summarize_corr2}()},
\code{\link{summarize_corr}()},
\code{\link{summarize_count}()},
\code{\link{summarize_covar}()},
\code{\link{summarize_dot_product}()},
\code{\link{summarize_ema_half_life}()},
\code{\link{summarize_ewma}()},
\code{\link{summarize_kurtosis}()},
\code{\link{summarize_max}()},
\code{\link{summarize_min}()},
\code{\link{summarize_nth_central_moment}()},
\code{\link{summarize_nth_moment}()},
\code{\link{summarize_product}()},
\code{\link{summarize_quantile}()},
\code{\link{summarize_skewness}()},
\code{\link{summarize_stddev}()},
\code{\link{summarize_sum}()},
\code{\link{summarize_var}()},
\code{\link{summarize_weighted_avg}()},
\code{\link{summarize_weighted_corr}()},
\code{\link{summarize_weighted_covar}()},
\code{\link{summarize_z_score}()}
}
\concept{summarizers}
