% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparkavro.R
\name{spark_read_avro}
\alias{spark_read_avro}
\title{Reads a Avro File into Apache Spark}
\usage{
spark_read_avro(sc, name, path, readOptions = list(), repartition = 0L,
  memory = TRUE, overwrite = TRUE)
}
\arguments{
\item{sc}{An active \code{spark_connection}.}

\item{name}{The name to assign to the newly generated table.}

\item{path}{The path to the file. Needs to be accessible from the cluster.
Supports the \samp{"hdfs://"}, \samp{"s3n://"} and \samp{"file://"} protocols.}

\item{readOptions}{A list of strings with additional options.}

\item{repartition}{The number of partitions used to distribute the
generated table. Use 0 (the default) to avoid partitioning.}

\item{memory}{Boolean; should the data be loaded eagerly into memory? (That
is, should the table be cached?)}

\item{overwrite}{Boolean; overwrite the table with the given name if it
already exists?}
}
\description{
Reads a Avro file into Apache Spark using sparklyr.
}
\examples{
\dontrun{
## If you haven't got a Spark cluster, you can install Spark locally like this
library(sparklyr)
spark_install(version = "2.0.1")

sc <- spark_connect(master = "local")
df <- spark_read_avro(
  sc,
  "twitter",
  system.file("extdata/twitter.avro", package = "sparkavro"),
  repartition = FALSE,
  memory = FALSE,
  overwrite = FALSE
)

spark_disconnect(sc)
}
}
