% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrs_data_proc.R
\name{sim_resonances}
\alias{sim_resonances}
\title{Simulate a MRS data object containing a set of simulated resonances.}
\usage{
sim_resonances(
  freq = 0,
  amp = 1,
  lw = 0,
  lg = 0,
  phase = 0,
  freq_ppm = TRUE,
  acq_paras = def_acq_paras(),
  fp_scale = TRUE,
  back_extrap_pts = 0
)
}
\arguments{
\item{freq}{resonance frequency.}

\item{amp}{resonance amplitude.}

\item{lw}{line width in Hz.}

\item{lg}{Lorentz-Gauss lineshape parameter (between 0 and 1).}

\item{phase}{phase in degrees.}

\item{freq_ppm}{frequencies are given in ppm units if set to TRUE, otherwise
Hz are assumed.}

\item{acq_paras}{list of acquisition parameters. See
\code{\link{def_acq_paras}}}

\item{fp_scale}{multiply the first data point by 0.5.}

\item{back_extrap_pts}{number of data points to back extrapolate.}
}
\value{
MRS data object.
}
\description{
Simulate a MRS data object containing a set of simulated resonances.
}
\examples{
sim_data <- sim_resonances(freq = 2, lw = 5)
}
