% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometrical_functions.R
\name{snapPointsToLines2}
\alias{snapPointsToLines2}
\title{Snap points to lines}
\usage{
snapPointsToLines2(points, lines, idField = NA, snap_dist = 300, max_iter = 10)
}
\arguments{
\item{points}{A SpatialPointsDataFrame}

\item{lines}{A SpatialLinesDataFrame}

\item{idField}{The name of the column to use as index for the lines}

\item{snap_dist}{A distance (float) given to find for each point its
nearest line in a spatial index. A too big value will produce
unnecessary distance calculations and a too short value will lead to
more iterations to find neighbours. In extrem cases, a too short value
could lead to points not associated with lines (index = -1).}

\item{max_iter}{An integer indicating how many iteration the search
algorithm must perform in the spatial index to find lines close to a
point. At each iteration, the snap_dist is doubled to find candidates.}
}
\value{
A SpatialPointsDataFrame with the projected geometries
}
\description{
Snap points to their nearest lines (edited from maptools)
}
\examples{
# reading the data
networkgpkg <- system.file("extdata", "networks.gpkg", package = "spNetwork", mustWork = TRUE)
mtl_network <- rgdal::readOGR(networkgpkg,layer="mtl_network", verbose=FALSE)
eventsgpkg <- system.file("extdata", "events.gpkg", package = "spNetwork", mustWork = TRUE)
bike_accidents <- rgdal::readOGR(eventsgpkg,layer="bike_accidents", verbose=FALSE)
mtl_network$LineID <- 1:nrow(mtl_network)
# snapping point to lines
snapped_points <- snapPointsToLines2(bike_accidents,
    mtl_network,
    "LineID"
)
}
\keyword{internal}
