% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/k_functions.R
\name{kfunctions.mc}
\alias{kfunctions.mc}
\title{Network k and g functions (multicore, maturing)}
\usage{
kfunctions.mc(
  lines,
  points,
  start,
  end,
  step,
  width,
  nsim,
  conf_int = 0.05,
  digits = 2,
  tol = 0.1,
  resolution = 50,
  agg = NULL,
  verbose = TRUE
)
}
\arguments{
\item{lines}{A SpatialLinesDataFrame representing the underlying network. The
geometries must be a SpatialLinesDataFrame (may crash if some geometries
 are invalid) without MultiLineSring}

\item{points}{A SpatialPointsDataFrame representing the points on the
network. These points will be snapped on their nearest line}

\item{start}{A double, the lowest distance used to evaluate the k and g functions}

\item{end}{A double, the highest distance used to evaluate  the k and g functions}

\item{step}{A double, the step between two evaluations of the k and g
function. start, end and step are used to create a vector of distances with the function seq}

\item{width}{The width of each donut for the g-function. Half of the width is applied on
both sides of the considered distance}

\item{nsim}{An integer indicating the number of Monte Carlo simulations
to perform for inference}

\item{conf_int}{A double indicating the width confidence interval (default =
0.05) calculated on the Monte Carlo simulations}

\item{digits}{An integer indicating the number of digits to retain from the
spatial coordinates}

\item{tol}{When adding the points to the network, specify the minimum
distance between these points and the lines' extremities. When points are
closer, they are added at the extremity of the lines}

\item{resolution}{When simulating random points on the network, selecting a
resolution will reduce greatly the calculation time. When resolution is null
the random points can occur everywhere on the graph. If a value is specified,
the edges are split according to this value and the random points can only be
vertices on the new network}

\item{agg}{A double indicating if the events must be aggregated within a distance.
If NULL, the events are aggregated only by rounding the coordinates}

\item{verbose}{A Boolean indicating if progress messages should be displayed}
}
\value{
A list with the following values : \cr \itemize{ \item{plotk}{ A
  ggplot2 object representing the values of the k-function} \item{plotg}{ A
  ggplot2 object representing the values of the g-function} \item{values}{ A
  DataFrame with the values used to build the plots} }
}
\description{
Calculate the k and g functions for a set of points on a network
  with multicore support. For details, please see the function kfunctions.
  (maturing)
}
\details{
For details, please look at the function kfunctions.
}
\examples{
\donttest{
networkgpkg <- system.file("extdata", "networks.gpkg", package = "spNetwork", mustWork = TRUE)
eventsgpkg <- system.file("extdata", "events.gpkg", package = "spNetwork", mustWork = TRUE)
main_network_mtl <- rgdal::readOGR(networkgpkg,layer="main_network_mtl", verbose=FALSE)
mtl_libraries <- rgdal::readOGR(eventsgpkg,layer="mtl_libraries", verbose=FALSE)
future::plan(future::multisession(workers=2))
result <- kfunctions.mc(main_network_mtl, mtl_libraries,
     start = 0, end = 2500, step = 10,
     width = 200, nsim = 50,
     conf_int = 0.05, tol = 0.1, agg = NULL,
     verbose = FALSE)
## make sure any open connections are closed afterward
if (!inherits(future::plan(), "sequential")) future::plan(future::sequential)
}
}
