% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lp_irf.R
\name{rlp_irf}
\alias{rlp_irf}
\title{Estimate regime-dependent impulse response functions}
\usage{
rlp_irf(rlp, CI = c(0.1, 0.9))
}
\arguments{
\item{rlp}{RLP output}

\item{CI}{numeric vector: c(lower ci bound, upper ci bound)}
}
\value{
list of long-form data.frame with one row per target-shock-horizon identifier
}
\description{
Estimate regime-dependent impulse response functions
}
\examples{
\donttest{

  # simple time series
  AA = c(1:100) + rnorm(100)
  BB = c(1:100) + rnorm(100)
  CC = AA + BB + rnorm(100)
  date = seq.Date(from = as.Date('2000-01-01'), by = 'month', length.out = 100)
  Data = data.frame(date = date, AA, BB, CC)
  # add regime
  Data = dplyr::mutate(Data, reg = dplyr::if_else(AA > median(AA), 1, 0))

  # local projection forecasts
  rlp =
    sovereign::RLP(
      data = Data,
      regime = 'reg',
      horizon = c(1:10),
      freq = 'month',
      p = 1,,
      type =  'const',
      NW = TRUE,
      NW_lags = 1,
      NW_prewhite = FALSE)

 # impulse response function
 rirf = sovereign::rlp_irf(rlp)
}

}
\seealso{
\code{\link[=LP]{LP()}}

\code{\link[=lp_irf]{lp_irf()}}

\code{\link[=RLP]{RLP()}}

\code{\link[=rlp_irf]{rlp_irf()}}
}
