% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var.R
\name{VAR}
\alias{VAR}
\title{Estimate VAR}
\usage{
VAR(
  data,
  horizon = 10,
  freq = "month",
  type = "const",
  p = 1,
  lag.ic = NULL,
  lag.max = NULL
)
}
\arguments{
\item{data}{data.frame, matrix, ts, xts, zoo: Endogenous regressors}

\item{horizon}{int: forecast horizons}

\item{freq}{string: frequency of data ('day', 'week', 'month', 'quarter', or 'year')}

\item{type}{string: type of deterministic terms to add ('none', 'const', 'trend', or 'both')}

\item{p}{int: lags}

\item{lag.ic}{string: information criterion to choose the optimal number of lags ('AIC' or 'BIC')}

\item{lag.max}{int: maximum number of lags to test in lag selection}
}
\value{
list object with elements \code{data}, \code{model}, \code{forecasts}, \code{residuals}
}
\description{
Estimate VAR
}
\examples{
\donttest{

 # simple time series
 AA = c(1:100) + rnorm(100)
 BB = c(1:100) + rnorm(100)
 CC = AA + BB + rnorm(100)
 date = seq.Date(from = as.Date('2000-01-01'), by = 'month', length.out = 100)
 Data = data.frame(date = date, AA, BB, CC)

 # estimate VAR
  var =
    sovereign::VAR(
      data = Data,
      horizon = 10,
      freq = 'month',
      lag.ic = 'BIC',
      lag.max = 4)

# impulse response functions
var.irf = sovereign::var_irf(var)

# forecast error variance decomposition
var.fevd = sovereign::var_fevd(var)

}

}
\seealso{
\code{\link[=VAR]{VAR()}}

\code{\link[=var_irf]{var_irf()}}

\code{\link[=var_fevd]{var_fevd()}}

\code{\link[=RVAR]{RVAR()}}

\code{\link[=rvar_irf]{rvar_irf()}}

\code{\link[=rvar_fevd]{rvar_fevd()}}
}
