% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchPars.R
\name{wigglePars}
\alias{wigglePars}
\title{Wiggle parameters}
\usage{
wigglePars(parList, parsToWiggle, probMutation, stepVariance)
}
\arguments{
\item{parList}{full list of considered parameters}

\item{parsToWiggle}{a list of the names of pars that might be mutated}

\item{probMutation}{the probability of a parameter mutating per iteration}

\item{stepVariance}{scale factor for calculating the size of mutations}
}
\description{
Internal soundgen function
}
\details{
Helper function for \code{\link{matchPars}}. Takes a list of control
parameters for \code{\link{soundgen}} and introduces some random variation in
their values.
}
\examples{
soundgen:::wigglePars(
  parList = list(
    sylLen = 250,
    pitch = data.frame(time = c(0, 1), value = c(200, 300))
  ),
  parsToWiggle = c('sylLen', 'pitch'),
  probMutation = .75,
  stepVariance = .5
)
}
\keyword{internal}
