% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_math.R
\name{gaussianSmooth2D}
\alias{gaussianSmooth2D}
\title{Gaussian smoothing in 2D}
\usage{
gaussianSmooth2D(m, kernelSize = 5, kernelSD = 0.5, plotKernel = FALSE)
}
\arguments{
\item{m}{input matrix (numeric, on any scale, doesn't have to be square)}

\item{kernelSize}{the size of the Gaussian kernel, in points}

\item{kernelSD}{the SD of the Gaussian kernel relative to its size (.5 = the
edge is two SD's away)}

\item{plotKernel}{if TRUE, plots the kernel}
}
\value{
Returns a numeric matrix of the same dimensions as input.
}
\description{
Takes a matrix of numeric values and smoothes it by convolution with a
symmetric Gaussian window function.
}
\examples{
s = spectrogram(soundgen(), samplingRate = 16000,
  output = 'original', plot = FALSE)
# image(log(s))
s1 = gaussianSmooth2D(s, kernelSize = 11, plotKernel = TRUE)
# image(log(s1))
}
\seealso{
\code{\link{modulationSpectrum}}
}
