% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formants.R
\name{transplantFormants}
\alias{transplantFormants}
\title{Transplant formants}
\usage{
transplantFormants(donor, freqWindow_donor = NULL, recipient,
  freqWindow_recipient = NULL, samplingRate = NULL,
  dynamicRange = 80, windowLength = 50, step = NULL, overlap = 90,
  wn = "gaussian", zp = 0)
}
\arguments{
\item{donor}{the sound that provides the formants}

\item{freqWindow_donor, freqWindow_recipient}{the width of smoothing window.
Defaults to median pitch of each respective sound estimated by
\code{\link{analyze}}}

\item{recipient}{the sound that receives the formants}

\item{samplingRate}{sampling rate of \code{x} (only needed if \code{x} is a
numeric vector, rather than an audio file)}

\item{dynamicRange}{dynamic range, dB. All values more than one dynamicRange
under maximum are treated as zero}

\item{windowLength}{length of FFT window, ms}

\item{step}{you can override \code{overlap} by specifying FFT step, ms}

\item{overlap}{overlap between successive FFT frames, \%}

\item{wn}{window type: gaussian, hanning, hamming, bartlett, rectangular,
blackman, flattop}

\item{zp}{window length after zero padding, points}
}
\description{
Takes the general spectral envelope of one sound (\code{donor}) and
"transplants" it onto another sound (\code{recipient}). For biological sounds
like speech or animal vocalizations, this has the effect of replacing the
formants in the recipient sound while preserving the original intonation and
(to some extent) voice quality. Note that \code{freqWindow_donor} and
\code{freqWindow_recipient} are crucial parameters that regulate the amount
of spectral smoothing in both sounds. The default is to set them to the
estimated median pitch, but this is time-consuming and error-prone, so set
them to reasonable values manually if possible.
}
\details{
Algorithm: makes spectrograms of both sounds, interpolates and smoothes the
donor spectrogram, flattens the recipient spectrogram, multiplies the
spectrograms, and transforms back into time domain with inverse STFT.
}
\examples{
\dontrun{
# Objective: take formants from the bleating of a sheep and apply them to a
# synthetic sound with any arbitrary duration, intonation, nonlinearities etc
data(sheep, package = 'seewave')  # import a recording from seewave
donor = as.numeric(scale(sheep@left))  # source of formants
samplingRate = sheep@samp.rate
playme(donor, samplingRate)
spectrogram(donor, samplingRate, osc = TRUE)
seewave::meanspec(donor, f = samplingRate, dB = 'max0')

s1 = transplantFormants(
  donor = donor,
  recipient = soundgen(sylLen = 1200,
                       pitch = c(100, 300, 250, 200),
                       vibratoFreq = 9, vibratoDep = 1,
                       samplingRate = samplingRate),
  samplingRate = samplingRate)
playme(s1, samplingRate)
spectrogram(s1, samplingRate, osc = TRUE)
seewave::meanspec(s1, f = samplingRate, dB = 'max0')

s2 = transplantFormants(
  donor = donor,
  recipient = soundgen(sylLen = 1500,
                       pitch = c(150, 200, 120),
                       nonlinBalance = 50,
                       subFreq = 80, subDep = 50, jitterDep = 0,
                       noise = -20,
                       samplingRate = samplingRate),
  samplingRate = samplingRate)
playme(s2, samplingRate)
spectrogram(s2, samplingRate, osc = TRUE)
seewave::meanspec(s2, f = samplingRate, dB = 'max0')
}
}
\seealso{
\code{\link{getSpectralEnvelope}} \code{\link{addFormants}}
  \code{\link{soundgen}}
}
