% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postprocessing.R
\name{fade}
\alias{fade}
\title{Fade}
\usage{
fade(x, fadeIn = 1000, fadeOut = 1000, samplingRate = NULL,
  shape = c("lin", "exp", "log", "cos", "logistic")[1], steepness = 1,
  plot = FALSE)
}
\arguments{
\item{x}{zero-centered (!) numeric vector such as a waveform}

\item{fadeIn, fadeOut}{length of segments for fading in and out, interpreted
as points if \code{samplingRate = NULL} and as ms otherwise (0 = no fade)}

\item{samplingRate}{sampling rate of the input vector, Hz}

\item{shape}{controls the type of fade function: 'lin' = linear, 'exp' =
exponential, 'log' = logarithmic, 'cos' = cosine, 'logistic' = logistic
S-curve}

\item{steepness}{scaling factor regulating the steepness of fading curves if
the shape is 'exp', 'log', or 'logistic' (0 = linear, >1 = steeper than
default)}

\item{plot}{if TRUE, produces an oscillogram of the waveform after fading}
}
\value{
Returns a numeric vector of the same length as input
}
\description{
Applies fade-in and/or fade-out of variable length, shape, and steepness. The
resulting effect softens the attack and release of a waveform.
}
\examples{
#' # Fading a real sound: say we want fast attack and slow release
s = soundgen(attack = 0, windowLength = 10,
             sylLen = 500, addSilence = 0)
# playme(s)
# plot(s, type = 'l')
s1 = fade(s, fadeIn = 10, fadeOut = 350,
          samplingRate = 16000, shape = 'cos')
# playme(s1)
# plot(s1, type = 'l')


# Illustration of fade shapes
x = runif(5000, min = -1, max = 1)  # make sure to zero-center input!!!
# plot(x, type = 'l')
y = fade(x, fadeIn = 1000, fadeOut = 0, plot = TRUE)
y = fade(x,
         fadeIn = 1000,
         fadeOut = 1500,
         shape = 'exp',
         plot = TRUE)
y = fade(x,
         fadeIn = 1500,
         fadeOut = 500,
         shape = 'log',
         plot = TRUE)
y = fade(x,
         fadeIn = 1500,
         fadeOut = 500,
         shape = 'log',
         steepness = 8,
         plot = TRUE)
y = fade(x,
         fadeIn = 1000,
         fadeOut = 1500,
         shape = 'cos',
         plot = TRUE)
y = fade(x,
         fadeIn = 1500,
         fadeOut = 500,
         shape = 'logistic',
         steepness = 4,
         plot = TRUE)
}
\seealso{
\code{\link{crossFade}}
}
