% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/source.R
\name{generateHarmonics}
\alias{generateHarmonics}
\title{Generate harmonics}
\usage{
generateHarmonics(pitch, glottisAnchors = 0, attackLen = 50,
  nonlinBalance = 0, nonlinDep = 50, nonlinRandomWalk = NULL,
  jitterDep = 0, jitterLen = 1, vibratoFreq = 5, vibratoDep = 0,
  shimmerDep = 0, shimmerLen = 1, creakyBreathy = 0, rolloff = -9,
  rolloffOct = 0, rolloffKHz = 0, rolloffParab = 0,
  rolloffParabHarm = 3, rolloff_perAmpl = 0, rolloffExact = NULL,
  temperature = 0.025, pitchDriftDep = 0.5, pitchDriftFreq = 0.125,
  amplDriftDep = 5, subDriftDep = 4, rolloffDriftDep = 3,
  randomWalk_trendStrength = 0.5, shortestEpoch = 300, subFreq = 100,
  subDep = 0, amplAnchors = NA, interpol = c("approx", "spline",
  "loess")[3], overlap = 75, samplingRate = 16000, pitchFloor = 75,
  pitchCeiling = 3500, pitchSamplingRate = 3500, dynamicRange = 80)
}
\arguments{
\item{pitch}{a contour of fundamental frequency (numeric vector). NB: for
computational efficiency, provide the pitch contour at a reduced sampling
rate pitchSamplingRate, eg 3500 points/s. The pitch contour will be
upsampled before synthesis.}

\item{glottisAnchors}{anchors for specifying the proportion of a
glottal cycle with closed glottis, \% (0 = no modification, 100 = closed
phase as long as open phase); numeric vector or dataframe specifying time
and value (anchor format)}

\item{attackLen}{duration of fade-in / fade-out at each end of syllables and
noise (ms): a vector of length 1 (symmetric) or 2 (separately for fade-in
and fade-out)}

\item{nonlinBalance}{hyperparameter for regulating the (approximate)
proportion of sound with different regimes of pitch effects (none /
subharmonics only / subharmonics and jitter). 0\% = no noise; 100\% = the
entire sound has jitter + subharmonics. Ignored if temperature = 0}

\item{nonlinDep}{hyperparameter for regulating the intensity of subharmonics
and jitter, 0 to 100\% (50\% = jitter and subharmonics are as specified,
<50\% weaker, >50\% stronger). Ignored if temperature = 0}

\item{nonlinRandomWalk}{a numeric vector specifying the timing of nonliner
regimes: 0 = none, 1 = subharmonics, 2 = subharmonics + jitter + shimmer}

\item{jitterDep}{cycle-to-cycle random pitch variation, semitones (anchor
format)}

\item{jitterLen}{duration of stable periods between pitch jumps, ms. Use a
low value for harsh noise, a high value for irregular vibrato or shaky
voice (anchor format)}

\item{vibratoFreq}{the rate of regular pitch modulation, or vibrato, Hz
(anchor format)}

\item{vibratoDep}{the depth of vibrato, semitones (anchor format)}

\item{shimmerDep}{random variation in amplitude between individual glottal
cycles (0 to 100\% of original amplitude of each cycle) (anchor format)}

\item{shimmerLen}{duration of stable periods between amplitude jumps, ms. Use
a low value for harsh noise, a high value for shaky voice (anchor format)}

\item{creakyBreathy}{hyperparameter for a rough adjustment of voice quality
from creaky (-1) to breathy (+1); 0 = no change}

\item{rolloff}{basic rolloff from lower to upper harmonics, db/octave
(exponential decay). All rolloff parameters are in anchor format. See
\code{\link{getRolloff}} for more details}

\item{rolloffOct}{basic rolloff changes from lower to upper harmonics
(regardless of f0) by \code{rolloffOct} dB/oct. For example, we can get
steeper rolloff in the upper part of the spectrum}

\item{rolloffKHz}{rolloff changes linearly with f0 by \code{rolloffKHz}
dB/kHz. For ex., -6 dB/kHz gives a 6 dB steeper basic rolloff as f0 goes up
by 1000 Hz}

\item{rolloffParab}{an optional quadratic term affecting only the first
\code{rolloffParabHarm} harmonics. The middle harmonic of the first
\code{rolloffParabHarm} harmonics is amplified or dampened by
\code{rolloffParab} dB relative to the basic exponential decay}

\item{rolloffParabHarm}{the number of harmonics affected by
\code{rolloffParab}}

\item{rolloff_perAmpl}{as amplitude goes down from max to
\code{-dynamicRange}, \code{rolloff} increases by \code{rolloff_perAmpl}
dB/octave. The effect is to make loud parts brighter by increasing energy
in higher frequencies}

\item{rolloffExact}{user-specified exact strength of harmonics: a vector or
matrix with one row per harmonic, scale 0 to 1 (overrides all other rolloff
parameters)}

\item{temperature}{hyperparameter for regulating the amount of stochasticity
in sound generation}

\item{pitchDriftDep}{scale factor regulating the effect of temperature on the
amount of slow random drift of f0 (like jitter, but slower): the higher,
the more f0 "wiggles" at a given temperature}

\item{pitchDriftFreq}{scale factor regulating the effect of temperature on
the frequency of random drift of f0 (like jitter, but slower): the higher,
the faster f0 "wiggles" at a given temperature}

\item{randomWalk_trendStrength}{try 0 to 1 - the higher, the more likely rw
is to get high in the middle and low at the beginning and end (i.e. max
effect amplitude in the middle of a sound)}

\item{shortestEpoch}{minimum duration of each epoch with unchanging
subharmonics regime, in ms}

\item{subFreq}{target frequency of subharmonics, Hz (lower than f0, adjusted
dynamically so f0 is always a multiple of subFreq) (anchor format)}

\item{subDep}{the width of subharmonic band, Hz. Regulates how quickly the
strength of subharmonics fades as they move away from harmonics in f0 stack
(anchor format)}

\item{amplAnchors}{amplitude envelope (dB, 0 = max amplitude) (anchor
format)}

\item{interpol}{the method of smoothing envelopes based on provided anchors:
'approx' = linear interpolation, 'spline' = cubic spline, 'loess' (default)
= polynomial local smoothing function. NB: this does not affect contours for
"noise", "glottal", and the smoothing of formants}

\item{overlap}{FFT window overlap, \%. For allowed values, see
\code{\link[seewave]{istft}}}

\item{samplingRate}{sampling frequency, Hz}

\item{pitchFloor}{lower & upper bounds of f0}

\item{pitchCeiling}{lower & upper bounds of f0}

\item{pitchSamplingRate}{sampling frequency of the pitch contour only, Hz.
Low values reduce processing time. Set to \code{pitchCeiling} for optimal
speed or to \code{samplingRate} for optimal quality}

\item{dynamicRange}{dynamic range, dB. Harmonics and noise more than
dynamicRange under maximum amplitude are discarded to save computational
resources}
}
\description{
Internal soundgen function.
}
\details{
Returns one continuous, unfiltered, voiced syllable consisting of several
sine waves.
}
\examples{
rolloffExact1 = c(.2, .2, 1, .2, .2)
s1 = soundgen:::generateHarmonics(pitch = seq(400, 530, length.out = 1500),
                       rolloffExact = rolloffExact1)
spectrogram(s1, 16000, ylim = c(0, 4))
# playme(s1, 16000)

rolloffExact2 = matrix(c(.2, .2, 1, .2, .2,
                         1, .5, .2, .1, .05), ncol = 2)
s2 = soundgen:::generateHarmonics(pitch = seq(400, 530, length.out = 1500),
                       rolloffExact = rolloffExact2)
spectrogram(s2, 16000, ylim = c(0, 4))
# playme(s2, 16000)
}
\keyword{internal}
