% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_math.R
\name{interpolMatrix}
\alias{interpolMatrix}
\title{Interpolate matrix}
\usage{
interpolMatrix(m, nr, nc, interpol = c("approx", "spline")[1])
}
\arguments{
\item{m}{input matrix of numeric values}

\item{nr, nc}{target dimensions}

\item{interpol}{the method of smoothing envelopes based on provided anchors:
'approx' = linear interpolation, 'spline' = cubic spline, 'loess' (default)
= polynomial local smoothing function. NB: this does not affect contours for
"noise", "glottal", and the smoothing of formants}
}
\description{
Internal soundgen function
}
\details{
Performs a chosen type of interpolation (linear or smooth) across both rows and columns of a matrix, in effect up- or downsampling a matrix to required dimensions
}
\examples{
m = matrix(1:12 + rnorm(12, 0, .2), nrow = 3)
soundgen:::interpolMatrix(m, nr = 10, nc = 7)
soundgen:::interpolMatrix(m, nr = 10, nc = 7, interpol = 'spline')
soundgen:::interpolMatrix(m, nr = 2, nc = 7)
soundgen:::interpolMatrix(m, nr = 2, nc = 2)
}
\keyword{internal}
