% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchPars.R
\name{getMelSpec}
\alias{getMelSpec}
\title{Mel-transformed spectrum}
\usage{
getMelSpec(s, samplingRate = NULL, windowLength = 40, overlap = 50,
  step = NULL, dynamicRange = 80, maxFreq = NULL, plot = FALSE)
}
\arguments{
\item{s}{input sound (path to a .wav file or numeric vector)}

\item{samplingRate}{sampling rate of \code{target} (only needed if target is
a numeric vector, rather than a .wav file)}

\item{windowLength}{length of FFT window, ms}

\item{overlap}{overlap between successive FFT frames, \%}

\item{step}{you can override \code{overlap} by specifying FFT step, ms}

\item{dynamicRange}{parts of the spectra quieter than \code{-dynamicRange} dB
are not compared}

\item{maxFreq}{parts of the spectra above \code{maxFreq} Hz are not compared}

\item{plot}{if TRUE, plots the spectrum}
}
\description{
Internal soundgen function
}
\details{
Takes a .wav file or a waveform as numeric vector + samplingRate and returns
mel-transformed spectrum (auditory spectrum). Calls
\code{\link[tuneR]{melfcc}}. See \code{\link{matchPars}}.
}
\keyword{internal}
