% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{long2wide}
\alias{long2wide}
\title{Convert from the long format (single entry per row) to the wide format (multiple entries per row).}
\usage{
long2wide(data, col.lang = "LANGUAGE", skip = NULL)
}
\arguments{
\item{data}{[data.frame] The dataset to be converted.}

\item{col.lang}{[character] Name of the column with language names. Defaults to \code{"LANGUAGE"}.}

\item{skip}{[character vector] Names of columns to not convert. Defaults to \code{NULL}.}
}
\value{
[data.frame] A data frame in the wide format (multiple entries per row).
}
\description{
Takes a data frame of word pairs/triples/..., each stored in multiple rows, and returns a data frame with the same words but each pair/triple/... stored in one row. WARNING: in the original data frame, entries from all languages must be in the same order.
}
\details{
Data for \code{\link{soundcorrs}} can be prepared in one of two formats: the 'long format' and the 'wide format'. In the 'long format', each row contains only a single word and metadata associated with it. In the 'wide format', each row contains the entire pair/triple/... of words, and all the metadata associated with them. The 'long format' is convenient for making sure that all the words in a pair/triple/... have the same number of segments, but it cannot be read directly by \code{\link{soundcorrs}}. \code{long2wide} and \code{\link{wide2long}} convert between the two formats.
}
\examples{
# path to sample data in the "long format"
fName <- system.file ("extdata", "data-abc.tsv", package="soundcorrs")
long <- read.table (fName, header=TRUE)
wide <- long2wide (long, skip=c("ID"))
}
\seealso{
\code{\link{wide2long}}
}
