% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastDoCall.R
\name{fastDoCall}
\alias{fastDoCall}
\title{An alternative to the internal \code{do.call}}
\usage{
fastDoCall(what, args, quote = FALSE, envir = parent.frame())
}
\arguments{
\item{what}{either a function or a non-empty character string naming the
    function to be called.}

\item{args}{a \emph{list} of arguments to the function call.  The
    \code{names} attribute of \code{args} gives the argument names.}

\item{quote}{a logical value indicating whether to quote the
    arguments.}

\item{envir}{an environment within which to evaluate the call.  This
    will be most useful if \code{what} is a character string and
    the arguments are symbols or quoted expressions.}
}
\description{
The \code{\link[base]{do.call}} can be somewhat slow, especially when working
with large objects. This function is based upon the suggestions from Hadley
Wickham on the R mailing list, see
\href{http://r.789695.n4.nabble.com/call-do-call-expression-too-big-td3574335.html}{here}.
Also thanks to \emph{Tommy} at StackOverflow for
\href{https://stackoverflow.com/questions/10022436/do-call-in-combination-with}{suggesting}
how to handle double and triple colon operators, \code{::}, further enhancing
the function.
}
\section{Note}{


  Note that this is an verbaim copy of fastDoCall function from Gmisc
  package. All credits for Max Gordon.
}

