\name{soilphysics-package}
\alias{soilphysics-package}
\alias{soilphysics}
\docType{package}

\title{ Soil Physical Analysis }

\description{
Basic and model-based soil physical analysis. 
}

\details{
\tabular{ll}{
Package: \tab soilphysics\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2013-12-28\cr
License: \tab GPL (>= 2)\cr
}
This package contains functions for modelling the soil water retention,
the load bearing capacity and the penetration resistance. There are some useful
and easy-to-use functions to perform parameter estimation of these models.
Methods to obtain the preconsolidation stress are avaliable, such as Casagrande (1936) and so on.
There is a function to determine the soil critical moisture and the maximum bulk density 
for one or more samples, based on the Proctor (1933) compaction test. Also, others utilities like a
function to calculate the soil liquid limit, the void ratio and to determine the maximum curvature
point are avaliable.
}

\note{
\emph{soilphysics} is an ongoing project.
We welcome any and all criticism, comments and suggestions.
}

\author{
Anderson Rodrigo da Silva, Renato Paiva de Lima

Maintainer: Anderson Rodrigo da Silva <anderson.agro@hotmail.com>
}

\references{
ABNT - Associacao Brasileira de Normas Tecnicas. (1990). \emph{Ensaio de
    adensamento unidimensional}: NBR 12007. Rio de Janeiro. 13p.

Arvidsson, J.; Keller, T. (2004). Soil precompression stress
    I. A survey of Swedish arable soils. \emph{Soil & Tillage Research}, 77:85-95.

Bowles, J. A. (1986). \emph{Engineering Properties of Soils and their
    Measurements}. 3rd ed. McGraw-Hill Book Company, Inc. NY, 218pp.

Busscher, W.J. (1990) Adjustment of flat-tipped penetrometer resistance
   data to common water content. \emph{Transactions of the ASAE}, 3:519-524.

Casagrande, A. (1936). \emph{The determination of the pre-consolidation
   load and its practical significance}. In: Proceedings of the
   International Conference on Soil Mech. and Found. Eng.
   (ICSMFE), Cambridge, MA, 22-26 June 1936, vol. 3. Harvard
   University, Cambridge, MA, USA, pp. 60-64.

Dexter, A. R. (2004). Soil physical quality Part I. Theory,
   effects of soil texture, density, and organic matter,
   and effects on root growth. \emph{Geoderma}, 120:201-214.

Dias Junior, M. S. (1994). \emph{Compression of three soils under longterm
   tillage and wheel traffic}. 1994. 114f. Ph.D. thesis - Michigan
   State University, East Lansing.

Dias Junior, M. S.; Pierce, F. J. (1995). A simple procedure for
   estimating preconsolidation pressure from soil compression curves.
   \emph{Soil Technology}, 8:139-151.

Genuchten, M.T. van. (1980) A closed form equation for predicting the
   hydraulic conductivity of unsaturated soils. \emph{Soil Science Society of
   America Journal}, 44:892-898.

Mualem, Y. (1976) A new model for predicting the hydraulic conductivity
   of unsaturated porous media. \emph{Water Resource Research}, 12:513-522.

Proctor, E. R. (1933). Design and constructionof rolled earth dams.
   \emph{Eng. News Record}, 3:245-284, 286-289, 348-351, 372-376.

Silva, A. P. et al. (2010). Indicadores da qualidade fisica do solo. In: Jong Van Lier, Q. (Ed).
   \emph{Fisica do solo}. Vicosa (MG): Sociedade Brasileira de Ciencia do Solo. p.541-281.

Sowers, G. F. (1965). Consistency. In: BLACK, C.A. (Ed.). \emph{Methods of soil analysis}.
   Madison: American Society of Agronomy. Part 1, p.391-399. (Agronomy, 9).

Sowers, G. F. (1965). Consistency. In: KLUTE, A. (Ed.). 2nd ed. \emph{Methods of soil analysis}.
   Madison: American Society of Agronomy. Part 1, p.545-566.
}
