% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_alldocs.R
\name{db_alldocs}
\alias{db_alldocs}
\title{List all docs in a given database.}
\usage{
db_alldocs(cushion, dbname, descending = NULL, startkey = NULL,
  endkey = NULL, limit = NULL, include_docs = FALSE, as = "list", ...)
}
\arguments{
\item{cushion}{A \code{Cushion} object. Required.}

\item{dbname}{Database name. (charcter)}

\item{descending}{Return in descending order? (logical)}

\item{startkey}{Document ID to start at. (character)}

\item{endkey}{Document ID to end at. (character)}

\item{limit}{Number document IDs to return. (numeric)}

\item{include_docs}{(logical) If \code{TRUE}, returns docs themselves,
in addition to IDs. Default: \code{FALSE}}

\item{as}{(character) One of list (default) or json}

\item{...}{Curl args passed on to one of the HTTP verbs (e.g,.
\code{\link[httr]{GET}}, \code{\link[httr]{POST}}, \code{\link[httr]{PUT}},
etc.)}
}
\value{
JSON as a character string or a list (determined by the
\code{as} parameter)
}
\description{
List all docs in a given database.
}
\examples{
\dontrun{
(x <- Cushion$new())

db_create(x, dbname='leothelion')
bulk_create(x, mtcars, dbname="leothelion")

db_alldocs(x, dbname="leothelion")
db_alldocs(x, dbname="leothelion", as='json')
db_alldocs(x, dbname="leothelion", limit=2)
db_alldocs(x, dbname="leothelion", limit=2, include_docs=TRUE)

# curl options
library('httr')
res <- db_alldocs(x, dbname="leothelion", config=verbose())
}
}

