% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copeland.R
\name{copelandScores}
\alias{copelandScores}
\alias{copelandRanking}
\title{Copeland-like method}
\usage{
copelandScores(powerRelation, elements = NULL)

copelandRanking(powerRelation)
}
\arguments{
\item{powerRelation}{A \code{PowerRelation} object created by \code{\link[=newPowerRelation]{newPowerRelation()}}}

\item{elements}{vector of elements of which to calculate their scores.
If \code{elements == NULL}, create vectors for all elements in \code{pr$elements}}
}
\value{
Score function returns a list of type \code{CopelandScores} and length of \code{powerRelation$elements}
(unless parameter \code{elements} is specified). Each element is a vector of 2 numbers,
the number of pairwise winning comparisons and the number of pairwise losing comparisons.
Those two numbers summed together gives us the actual ordinal Copeland score.

Ranking function returns corresponding \code{\link{SocialRankingSolution}} object.
}
\description{
Based on \code{\link[=cpMajorityComparison]{cpMajorityComparison()}}, add or subtract scores
based on how an element fares against the others.

\code{copelandRanking} returns the corresponding ranking.
}
\details{
\loadmathjax
Strongly inspired by the Copeland score of social choice theory \insertCite{1951Copeland}{socialranking},
the Copeland-like solution is based on the net flow of the CP-majority graph \insertCite{2021Manipulability}{socialranking}.

Individuals are ordered according to the number of pairwise winning comparisons, minus the number of pairwise losing comparisons,
over the set of all CP-comparisons.

More formally, in a given \verb{PowerRelation pr} with element \mjseqn{i}, count the number of elements
\mjeqn{j \in N \setminus \lbrace i \rbrace}{j in N - \{i\}} where
\code{\link{cpMajorityComparison}}\verb{(pr, i, j) >= 0} and subtract those where
\code{\link{cpMajorityComparison}}\verb{(pr, i, j) <= 0}.
}
\examples{
# (123 ~ 12 ~ 3 ~ 1) > (2 ~ 23) > 13
pr <- newPowerRelation(
  c(1,2,3),
  "~", c(1,2),
  "~", c(3),
  "~", c(1),
  ">", c(2),
  "~", c(2,3),
  ">", c(1,3)
)

# `1` = 1
# `2` = 0
# `3` = -1
copelandScores(pr)

# only calculate results for two elements
# `1` = 1
# `3` = -1
copelandScores(pr, c(1,3))

# or just one element
copelandScores(pr, 2)

# 1 > 2 > 3
copelandRanking(pr)

}
\references{
\insertRef{2021Manipulability}{socialranking}

\insertRef{1951Copeland}{socialranking}
}
\seealso{
Other CP-majority based functions: 
\code{\link{cpMajorityComparison}()},
\code{\link{kramerSimpsonScores}()}

Other score vector functions: 
\code{\link{cumulativeScores}()},
\code{\link{kramerSimpsonScores}()},
\code{\link{lexcelScores}()},
\code{\link{ordinalBanzhafScores}()}
}
\concept{CP-majority based functions}
\concept{score vector functions}
