% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsmi_dd.R
\name{lsmi_dd}
\alias{lsmi_dd}
\title{Network Degree Distribution Estimated from Labeled Snowball
Sample with Multiple Inclusion (LSMI)}
\usage{
lsmi_dd(x = NULL, net, ...)
}
\arguments{
\item{x}{the LSMI sample obtained from the network \code{net}, for example,
with \code{\link{lsmi}} function or as a subset of the output
by \code{\link{lsmi_union}}.}

\item{net}{a network object that is a list containing:
\describe{
  \item{\code{degree}}{the degree sequence of the network, which is
     an \code{integer} vector of length \eqn{n};}
  \item{\code{edges}}{the edgelist, which is a two-column
     matrix, where each row is an edge of the network;}
  \item{\code{n}}{the network order (i.e., number of nodes in the network).}
}
The network object can be simulated by \code{\link{random_network}},
selected from the networks available in \code{\link{artificial_networks}},
converged from an \code{igraph} object with \code{\link{igraph_to_network}},
etc.}

\item{...}{arguments passed to the \code{\link{lsmi}} function
(ignored if \code{x} is specified, see Details).}
}
\value{
A list object of class "\code{snowboot}" consisting of:
\item{fk}{A named numeric vector with estimated probabilities \eqn{\hat{f}(k)}
of degrees \eqn{k}, where \eqn{k = 0, 1, \ldots,} \code{max(c(ds, dns))}
(i.e., \eqn{k} ranges from 0 to the maximum node degree observed in the LSMI sample).
The names of the vector elements are \eqn{k}.}
\item{mu}{An estimate of the mean degree.}
\item{ds}{An integer vector of degrees of seed nodes.}
\item{dns}{An integer vector of degrees of non-seed nodes (i.e., nodes
recorded in the waves of neighbors).}
}
\description{
lsmi_dd computes an empirical network degree distribution and estimates
mean degree based on data from an LSMI sample from a network;
see Equations 6 and 7 by \insertCite{thompson_etal_2016;textual}{snowboot}
and Equation 1 by \insertCite{chen_etal_2018_snowboot;textual}{snowboot}
on the details of the calculations.
}
\details{
The samples produced with \code{\link{lsmi}} or \code{\link{lsmi_union}} contain
just node IDs arranged into lists of seeds and waves (no details on the
node degrees or other node features). This information is
sufficient to study some properties of a network (e.g., network motifs --
not yet implemented in the package). To estimate a degree distribution or
mean degree, both the LSMI sample and the original network object are required.
If the LSMI object \code{x} is not supplied, the function will attempt
sampling an LSMI automatically, using the arguments supplied in "\code{...}"
that will be passed to the \code{\link{lsmi}} function.
}
\examples{
net <- artificial_networks[[1]]

#Obtain an LSMI sample and, at the next step,
#use it to estimate the degree distribution:
lsmiSample <- lsmi(net, n.seed = 5, n.wave = 3)
fkEstimate1 <- lsmi_dd(lsmiSample, net)$fk

#Obtain an LSMI sample and estimate the degree
#distribution in a single step:
fkEstimate2 <- lsmi_dd(net = net, n.seed = 5, n.wave = 3)$fk

#Use the output of lsmi_union to get the estimate:
lsmiUnionSample <- lsmi_union(net, n.seeds = c(5, 10), n.wave = 3)
fkEstimate3 <- lsmi_dd(lsmiUnionSample$lsmi_big, net)$fk

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{lsmi}}, \code{\link{lsmi_union}}, \code{\link{boot_dd}}
}
