% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sk_sample.R
\name{sk_vario_fun}
\alias{sk_vario_fun}
\title{Theoretical variogram function}
\usage{
sk_vario_fun(pars, d = NULL)
}
\arguments{
\item{pars}{list of the form returned by \code{sk_pars} with entries 'y', 'x', 'eps', 'psill'}

\item{d}{numeric vector or list with vector entries 'y' and 'x', the distances to evaluate}
}
\value{
data frame (for list \code{d}) or numeric vector (for vector \code{d}) of variogram values
}
\description{
Computes the value of the variogram function w, defined by covariance model \code{pars}
at the component y and x lags supplied in \code{d}.
}
\details{
By definition w is Var( Z(s1) - Z(s2) ), where s1 and s2 are a pair of spatial
locations, and Z is the spatial process value. If Z is second-order stationary
then w only depends on the relative displacement, s1 - s2 = (dx, dy). \code{snapKrig}
models the variogram as W = 2 ( \code{eps} + \code{psill} ( 1 - cy(dy) cx(dx) ) ).

\code{sk_vario_fun} evaluates this function using the correlogram functions (cy and cx),
partial sill (\code{psill}) and nugget (\code{eps}) defined in \code{pars}, over the displacement
(dy and dx) supplied in \code{d}.

NOTE: w is twice the semi-variogram, usually denoted by greek letter gamma. Variogram
w is therefore often written 2\emph{gamma. This can (and does) lead to confusion in the
literature about whether to include a factor 2 in downstream calculations.
This function multiplies the semi-variogram function by 2, returning the variogram w
(ie 2}gamma), NOT the semi-variogram.

If \code{d} is a list, its 'y' and 'x' components should supply the y and x component distances.
These must be equal-length non-negative numeric vectors. The function returns the corresponding
variogram values in a vector of the same length.

If \code{d} is a numeric vector, it is interpreted as a set of distances at which to
evaluate the range of the variogram function. Anisotropic variograms will exhibit a range
of values for a given distance (depending on the relative sizes of the x and y components).
The function returns this range in a data frame with columns 'min' and 'max'.
}
\examples{
# set up example grid and parameters
gdim = c(10, 15)
d_max = sqrt(sum(gdim^2))
pars = sk_pars(gdim, 'mat')

# set up test distances
d_test = seq(0, d_max, length.out=1e2)

# evaluate and plot the variogram values for equal displacements along x and y
d_equal = stats::setNames(rep(list(sqrt(1/2)*d_test), 2), c('y', 'x'))
vario = sk_vario_fun(pars, d=d_equal)
plot(d_test, vario, pch=NA)
lines(d_test, vario, col='blue')

# evaluate and plot the range of variogram values (for all possible x and y displacements)
vario_lims = sk_vario_fun(pars, d=d_test)
lines(d_test, vario_lims[,1])
lines(d_test, vario_lims[,2])

}
\seealso{
sk_pars

Other variogram functions: 
\code{\link{sk_add_bins}()}
}
\concept{variogram functions}
\keyword{internal}
