% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sk_model.R
\name{sk_sim}
\alias{sk_sim}
\title{Random draw from multivariate normal distribution for sk grids}
\usage{
sk_sim(g, pars = sk_pars(g), n_layer = 1, fac = NULL, sk_out = TRUE)
}
\arguments{
\item{g}{an sk object or any grid object accepted by \code{sk}}

\item{pars}{list, covariance parameters in form returned by \code{sk_pars}}

\item{n_layer}{positive integer, the number of draws to return}

\item{fac}{list, optional pre-computed factorization of component correlation matrices}

\item{sk_out}{logical, if TRUE an sk grid is returned}
}
\value{
sk grid or its vectorized form (vector for single-layer case, matrix for multi-layer case)
}
\description{
Generates a random draw from the multivariate Gaussian distribution for the
covariance model \code{pars} on grid \code{g}, with mean zero.
}
\details{
\code{pars} and \code{g} define the model's covariance matrix V. This function uses \code{base::rnorm}
to get a vector of independent standard normal variates, which it multiplies by the square
root of the covariance matrix, V, for the desired model (as defined by \code{pars} and \code{g}). The
result has a multivariate normal distribution with mean zero and covariance V.

Multiple independent draws can be computed more efficiently by reusing the factorization
of V. This can be pre-computed with \code{sk_var} and supplied in \code{fac}, or users can set
\code{n_layer} and the function will do this automatically.
}
\examples{

# example grid and covariance parameters
gdim = c(100, 200)
g = sk(gdim)
pars_gau = sk_pars(g)

# this example has a large nugget effect
g_sim = sk_sim(g, pars_gau)
plot(g_sim)

# repeat with smaller nugget effect for less noisy data
pars_smooth = utils::modifyList(pars_gau, list(eps=1e-2))
g_sim = sk_sim(g, pars_smooth)
plot(g_sim)

# the nugget effect can be very small, but users should avoid eps=0
pars_smoother = utils::modifyList(pars_gau, list(eps=1e-12))
g_sim = sk_sim(g, pars_smoother)
plot(g_sim)

# multi-layer example
g_sim_multi = sk_sim(g, pars_smoother, n_layer=3)
plot(g_sim_multi, layer=1)
plot(g_sim_multi, layer=2)
plot(g_sim_multi, layer=3)

}
\seealso{
sk sk_pars base::rnorm

Other variance-related functions: 
\code{\link{sk_GLS}()},
\code{\link{sk_LL}()},
\code{\link{sk_cmean}()},
\code{\link{sk_nLL}()},
\code{\link{sk_var}()}
}
\concept{variance-related functions}
