% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_violin.R
\name{sm_violin}
\alias{sm_violin}
\title{A violin plot with jittered individual points}
\usage{
sm_violin(
  ...,
  violin.params = list(fill = "gray90", color = "transparent"),
  err.params = list(size = 1.2, linewidth = 1.2),
  point.params = list(alpha = 0.25, size = 2),
  errorbar_type = "sd",
  point_jitter_width = 0.17,
  points = TRUE,
  borders = TRUE,
  legends = FALSE,
  seed = NULL,
  forget = FALSE
)
}
\arguments{
\item{...}{A generic aesthetic parameter across points and the violin plot. This is optional.}

\item{violin.params}{List of parameters for the violin, such as color, alpha, fill etc}

\item{err.params}{List of parameters for the error bar, such as color, size, alpha etc}

\item{point.params}{List of parameters for individual points, such as color, alpha, fill etc}

\item{errorbar_type}{This argument determines the errorbar type.
If it is set to 'se', standard error bar will be shown.
If it is set to 'sd' (default), the error bar will display standard deviation.
If it is set to 'ci', the error bar will display 95\% confidence interval.}

\item{point_jitter_width}{A numerical value that determines the degree of the jitter for each point. If its 0,
all the points will have no jitter (aligned along the y-axis).}

\item{points}{TRUE if points need to be shown.
FALSE if points need to be hidden.}

\item{borders}{If the border needs to be displayed, the input should be TRUE.
If the border is not needed, the input should be FALSE.}

\item{legends}{If the legend needs to be displayed, the input should be TRUE.
If the legend is not needed, the input should be FALSE.}

\item{seed}{Random seed}

\item{forget}{Forget the defaults when list() is called for a specific parameter (ex. point.params).
Set to TRUE when when users want to map aesthetics to different groups more flexibly..
Set to FALSE by default.}
}
\value{
Violin plot generated using ggplot2
}
\description{
A violin plot with jittered individual points
}
\examples{
library(ggplot2)
library(smplot2)
set.seed(1) # generate random data
day1 = rnorm(16,2,1)
day2 = rnorm(16,5,1)
Subject <- rep(paste0('S',seq(1:16)), 2)
Data <- data.frame(Value = matrix(c(day1,day2),ncol=1))
Day <- rep(c('Day 1', 'Day 2'), each = length(day1))
df <- cbind(Subject, Data, Day)
# with aesthetic defaults of smplot
ggplot(data = df, mapping = aes(x = Day, y = Value, color = Day)) +
sm_violin() +
scale_color_manual(values = sm_color('blue','orange'))

# without aesthetic defaults of smplot
ggplot(data = df, mapping = aes(x = Day, y = Value, color = Day)) +
sm_violin(violin.params = list()) +
scale_color_manual(values = sm_color('blue','orange'))


}
