% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothedLasso.r
\name{fusedLasso}
\alias{fusedLasso}
\title{Auxiliary function which returns the objective, penalty, and dependence structure among regression coefficients of the fused Lasso.}
\usage{
fusedLasso(X, y, E, lambda, gamma)
}
\arguments{
\item{X}{The design matrix.}

\item{y}{The response vector.}

\item{E}{The adjacency matrix which encodes with a one in position \eqn{(i,j)} the presence of an edge between variables \eqn{i} and \eqn{j}. Note that only the upper triangle of \eqn{E} is read.}

\item{lambda}{The first regularization parameter of the fused Lasso.}

\item{gamma}{The second regularization parameter of the fused Lasso.}
}
\value{
A list with six functions, precisely the objective \eqn{u}, penalty \eqn{v}, and dependence structure \eqn{w}, as well as their derivatives \eqn{du}, \eqn{dv}, and \eqn{dw}.
}
\description{
Auxiliary function which returns the objective, penalty, and dependence structure among regression coefficients of the fused Lasso.
}
\examples{
library(smoothedLasso)
n <- 100
p <- 500
betavector <- runif(p)
X <- matrix(runif(n*p),nrow=n,ncol=p)
y <- X \%*\% betavector
E <- matrix(sample(c(TRUE,FALSE),p*p,replace=TRUE),p)
lambda <- 1
gamma <- 0.5
temp <- fusedLasso(X,y,E,lambda,gamma)

}
\references{
Tibshirani, R., Saunders, M., Rosset, S., Zhu, J., and Knight, K. (2005). Sparsity and Smoothness via the Fused Lasso. J Roy Stat Soc B Met, 67(1):91-108.

Arnold, T.B. and Tibshirani, R.J. (2020). genlasso: Path Algorithm for Generalized Lasso Problems. R package version 1.5.

Hahn, G., Lutz, S., Laha, N., and Lange, C. (2020). A framework to efficiently smooth L1 penalties for linear regression. bioRxiv:2020.09.17.301788.
}
