% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smbinning.R
\name{smbinning.gen}
\alias{smbinning.gen}
\title{Utility to generate a new characteristic from a numeric variable}
\usage{
smbinning.gen(df, ivout, chrname = "NewChar")
}
\arguments{
\item{df}{Dataset to be updated with the new characteristic.}

\item{ivout}{An object generated after \code{smbinning}.}

\item{chrname}{Name of the new characteristic.}
}
\value{
A data frame with the binned version of the characteristic analyzed with \code{smbinning}.
}
\description{
It generates a data frame with a new predictive characteristic after the binning process.
}
\examples{
# Package loading and data exploration
library(smbinning) # Load package and its data
data(chileancredit) # Load smbinning sample dataset (Chilean Credit)
chileancredit.train=subset(chileancredit,FlagSample==1)
chileancredit.test=subset(chileancredit,FlagSample==0)
result=smbinning(df=chileancredit.train,y="FlagGB",x="TOB",p=0.05) # Run and save result

# Generate new binned characteristic into a existing data frame
chileancredit.train=
smbinning.gen(chileancredit.train,result,"gTOB") # Update training sample
chileancredit=
  smbinning.gen(chileancredit,result,"gTOB") # Update population
sqldf("select gTOB,count(*) as Recs 
      from chileancredit group by gTOB") # Check new field counts 
}

