% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/smbinning.R
\name{smbinning.factor}
\alias{smbinning.factor}
\title{Binning on Factor Variables}
\usage{
smbinning.factor(df, y, x)
}
\arguments{
\item{df}{A data frame.}

\item{y}{Binary response variable (0,1). Integer (\code{int}) is required.
Name of \code{y} must not have a dot.}

\item{x}{A factor variable with at least 2 different values. Value \code{Inf} is not allowed.
Name of \code{x} must not have a dot.}
}
\value{
The command \code{smbinning.factor} generates and object containing the necessary info and utilities for binning.
The user should save the output result so it can be used
with \code{smbinning.plot}, \code{smbinning.sql}, and \code{smbinning.gen}.
}
\description{
It generates the output table for the uniques values of a given factor variable.
}
\examples{
# Package loading and data exploration
library(smbinning) # Load package and its data
data(chileancredit) # Load smbinning sample dataset (Chilean Credit)
str(chileancredit) # Quick description of the data
table(chileancredit$FlagGB) # Tabulate target variable

# Data transformation. Data type must be factor.
chileancredit$IncomeLevel= factor(chileancredit$IncomeLevel,
                                  levels=c(0,1,2,3,4,5),
                                  labels=c("00","01","02","03","04","05"))

# Training and testing samples (Just some basic formality for Modeling)
chileancredit.train=subset(chileancredit,FlagSample==1)
chileancredit.test=subset(chileancredit,FlagSample==0)

# Package application and results
result.train=smbinning.factor(df=chileancredit.train,
                               y="FlagGB",x="IncomeLevel")
result.train$ivtable
result.test=smbinning.factor(df=chileancredit.test,
                               y="FlagGB",x="IncomeLevel")
result.test$ivtable

# Plots
par(mfrow=c(2,2))
smbinning.plot(result.train,option="dist",sub="Income Level (Tranining Sample)")
smbinning.plot(result.train,option="badrate",sub="Income Level (Tranining Sample)")
smbinning.plot(result.test,option="dist",sub="Income Level (Test Sample)")
smbinning.plot(result.test,option="badrate",sub="Income Level (Test Sample)")
}

