% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movres.R
\name{fitMovRes}
\alias{fitMovRes}
\title{Fit a Moving-Resting Model with Embedded Brownian Motion}
\usage{
fitMovRes(data, start, likelihood = c("full", "composite"), logtr = FALSE,
  method = "Nelder-Mead", optim.control = list(),
  integrControl = integr.control())
}
\arguments{
\item{data}{a \code{data.frame} whose first column is the observation time,
and other columns are location coordinates.}

\item{start}{starting value of the model, a vector of three components
in the order of rate for moving, rate for resting, and volatility.}

\item{likelihood}{a character string specifying the likelihood type to
maximize in estimation. This can be "full" for full likelihood or
"composite' for composite likelihood.
full loglikelihood from hidden Markov model approach.}

\item{logtr}{logical, if TRUE parameters are estimated on the log scale.}

\item{method}{the method argument to feed \code{optim}.}

\item{optim.control}{a list of control to be passed to \code{optim}.}

\item{integrControl}{a list of control parameters for the \code{integrate}
function: rel.tol, abs.tol, subdivision.}
}
\value{
a list of the following components:
\item{estimate}{the esimated parameter vector}
\item{loglik}{maximized loglikelihood or composite loglikelihood
evaluated at the estimate}
\item{convergence}{convergence code from \code{optim}}
\item{likelihood}{likelihood type (full or composite) from the input}
}
\description{
Fit a Moving-Resting Model with Embedded Brownian Motion with animal
movement data at discretely observation times by maximizing a composite
likelihood constructed from the marginal density of increment.
}
\examples{
tgrid <- seq(0, 10, length=500)
set.seed(123)
## make it irregularly spaced
tgrid <- sort(sample(tgrid, 30)) # change to 400 for a larger sample
dat <- rMovRes(tgrid, 1, 2, 25, "m")

fit.fl <- fitMovRes(dat, start=c(2, 2, 20), likelihood = "full")
fit.fl

fit.cl <- fitMovRes(dat, start=c(2, 2, 20), likelihood = "composite")
fit.cl
\dontrun{
## old, very slow, unexported R code
fit.<- smam:::fitMovRes.cl(dat, start=c(2, 2, 2))
fit.cpp
}
}
\references{
Yan, J., Chen, Y., Lawrence-Apfel, K., Ortega, I. M., Pozdnyakoc, V.,
Williams, S., and Meyer, T. (2014) A moving-resting process with an
embedded Brownian motion for animal movements.
Population Ecology. 56(2): 401--415.
}

