\name{sm.monotonicity}
\alias{sm.monotonicity}
\title{
A test of monotonicity in a regression curve.
}
\description{
  This function uses the idea of a `critical bandwidth' to assess the 
  evidence that a regression curve is non-monotonic.  A hypothesis
  test is carried out by bootstrap methods and the empirical p-value
  is reported.  Response variables on a continuous scale or with binomial
  variation can be handled.
}
\usage{
sm.monotonicity(x, y, N = rep(1, length(y)), h, type = "continuous", ...)
}
\arguments{
\item{x}{
  a vector of covariate values.
}
\item{y}{
  a vector of responses observed at the covariate locations.
}
\item{N}{
  a vector of sample sizes at the covariate locations, when the
  responses have a binomial error structure.
}
\item{h}{
a smoothing parameter to be used in the construction of the nonparametric
regression estimates.  A normal kernel
function is used and \code{h} is its standard deviation(s).  However, if
this argument is omitted \code{h} will be selected automatically, using
the \code{method} which is currently active.  See \code{sm.options} and 
\code{h.select} for details.
}
\item{type}{
  an indicator of whether the response variable is on a \code{"continuous"}
  or \code{"binomial"} scale.
}
\item{\dots}{
  other optional parameters are passed to the \code{sm.options}
  function, through a mechanism which limits their effect only to this
  call of the function; some of those relevant for this function are 
  \code{add},
  \code{ngrid}, 
  \code{xlab}, 
  \code{ylab}, 
  \code{xlim}, 
  \code{ylim}, 
  \code{lty},
  \code{col};
  see the documentation of  \code{\link{sm.options}} for their
  description.
}}  
\value{
  a list containing the following items
  \item{p}{the p-value for the test of the null hypothesis that the
           true curve is monotonic.}
  \item{hcrit}{the `critical' smoothing parameter.  This is the smallest
           value which, when applied to the observed data, makes the 
           curve monotonic.}
  \item{h}{the smoothing parameter used for double-smoothing (see the
           reference below).}
}
\section{Side Effects}{
  a plot of the curves generated by the bootstrap procedure is produced, 
  unless the option \code{display="none"} is set.  Those curves which
  are non-monotonic, and therefore contribute to the empirical p-value,
  are drawn in red.
}
\details{
  The first reference below describes the statistical methods used in the function.
  The test is an extension of one by Silverman (1986) for density estimation.
}
\references{
   Bowman, A.W., Jones, M.C. and Gijbels, I. (1998).
   Testing monotonicity of regression.
   \emph{J.Comp.Graph.Stat.} 7, 489-500.
}
\seealso{
\code{\link{sm.regression}}, \code{\link{sm.options}}
}
\examples{
#     Radiocarbon dating data

provide.data(radioc)
ind     <- (Cal.age>5000 & Cal.age<6000)
cal.age <- Cal.age[ind]
rc.age  <- Rc.age[ind]
sm.monotonicity(cal.age, rc.age, method = "aicc", nboot = 200)

#     Hosmer & Lemeshow birth data

provide.data(birth)
sm.monotonicity(Lwt[Smoke == "N"], Low[Smoke == "N"], type = "binomial")
}
\keyword{smooth}
\keyword{regression}
