% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_soils_raster}
\alias{get_soils_raster}
\title{Download single SLGA soils raster subset}
\usage{
get_soils_raster(
  product = NULL,
  attribute = NULL,
  component = NULL,
  depth = NULL,
  aoi = NULL,
  skip_val = FALSE
)
}
\arguments{
\item{product}{Character, one of the options from column 'Short_Name' in
\code{\link[slga:slga_product_info]{slga_product_info}}, where Type =
'Soil'.}

\item{attribute}{Character, one of the options from column 'Code' in
\code{\link[slga:slga_attribute_info]{slga_attribute_info}}}

\item{component}{Character, one of 'VAL', 'CLO', or 'CHI'.}

\item{depth}{Integer, a number from 1 to 6.}

\item{aoi}{Vector of WGS84 coordinates defining a rectangular area of
interest. The vector may be specified directly in the order xmin, xmax,
ymin, ymax, or the function can derive an aoi from the boundary of an `sf`
or `raster` object.}

\item{skip_val}{boolean, filthy hack for point data requests, prevents double
validation expanding bbox size}
}
\value{
Raster dataset for a single combination of product, attribute,
  component, depth, and area of interest.
}
\description{
Retrieves SLGA gridded soil data in raster format from WCS service.
}
\note{
aoi's wider or taller than 1 decimal degree are retrievable, but be
  aware that download file size will be large. If you want a dataset that
  covers more than ~3x3', may be faster to download the full
  GeoTIFF from the CSIRO Data Access Portal and crop out your AOI using GDAL.
}
\keyword{internal}
