% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RugglesCKR-data.R
\docType{data}
\name{RugglesCKR}
\alias{RugglesCKR}
\title{Cork and Kerry Stone Row Data}
\format{A data frame with 41 rows and 5 variables:
 \describe{
   \item{Ref}{Site Ref}
   \item{NE.SW}{String indicating whether they are towards the NE or SW}
   \item{Az.Hill}{Azimuth of hill towards which the Stone Rows are pointing}
   \item{Alt.Hill}{Altitude of hill towards which the Stone Rows are pointing}
   \item{Dec.Hill}{Declination of hill towards which the Stone Rows are pointing}
   }}
\usage{
data(RugglesCKR)
}
\description{
Data from C.L.N. Ruggles' fieldwork on the Stone Rows of Cork and Kerry.
}
\examples{
data(RugglesCKR)
curv <- curvigram(RugglesCKR$Dec.Hill, 2)
plotCurv(curv)
}
\references{
Ruggles, C.L.N. (1999). \emph{Astronomy in Prehistoric Britain and Ireland}. Yale University Press.
}
\keyword{datasets}
