% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_poisson_anticoef.R
\name{gen_poisson_anticoef}
\alias{gen_poisson_anticoef}
\title{Generates Poisson Anticipated Coefficients}
\usage{
gen_poisson_anticoef(anticoef, mean_low, mean_high)
}
\arguments{
\item{anticoef}{input anticipated coefficients of the proper length for your model matrix}

\item{mean_low}{The low value of the mean value}

\item{mean_high}{The high value of the mean value}
}
\value{
Anticipated coefficients.
}
\description{
Generates Poisson Anticipated Coefficients
Solves the Poisson link function
mean = exp(beta0 + beta1 * x)
such that mean = mean_low when x = -1, and mean = mean_high when x = +1.
Equivalently, solves this set of equations for beta0 and beta1:
mean_low = exp(beta0 - beta1)
mean_high = exp(beta0 + beta1)
}
\keyword{internal}
