
skimr 1.0.5 (2019-01-05)
========================
This is likely to be the last release of skimr version 1.  Version 2
has major changes to the API. Users should review and prepare for 
those changes now. 

### BUG FIXES
  * Fix issue where multibyte characters were causing an error.
  * Fix problem in which purrr cannot find mean.default.

skimr 1.0.4 (2019-01-12)
========================

This is likely to be the last release of skimr version 1.  Version 2
has major changes to the API. Users should review and prepare for 
those changes now. 

### BUG FIXES
  * Fix failures in handling dplyr verbs related to upcoming release
     of dplyr 0.8.0.

skimr 1.0.3 (2018-06-06)
========================
### NEW FEATURES
  * You can use skim_with() with a nest list of functions:
     `skim_with(.list = mylist)` or `skim_with(!!!mylist)`
  * More polished display of subtables in default printing.

### BUG FIXES
  * Fix issue with conflict between knitr and skimr versions 
     of kable() that occurred intermittently.
  * Do not skim a class when the skimmer list is empty for that class.
  * Fix a mistake in a test of skim_print for top counts.

skimr 1.0.2 (2018-04-04)
========================
### NEW FEATURES
  * You can create skimmers with the formula syntax from `rlang`:
    `skim_with(iqr = ~IQR(.x, na.rm = TRUE))`.

### MAJOR CHANGES
  * The median label has been changed to p50 for consistency with 
     the previous changes to p0 and p100. 

### MINOR IMPROVEMENTS
   * Impovements and corrections to to readme and other documentation.
   * New vignette showing defaults for skimmers and formats.
   * Vector output match data frame output more closely.
   * Add minimum required version for testhat.
   * Add minimum requred version for knitr.

### BUG FIXES
  * You can use `skim_with()` to add and remove skimmers at the same time, i.e.
    `skim_with(iqr = IQR, hist = NULL)` works as expected.
  * Histograms work when Inf or -Inf are present.
  * Change seq( ) parameter to length.out to avoid problems with name matching.
  * Summary should not display a data frame name of "." 
    (which occurs when piping begins with the data frame).

skimr 1.0.1 (2018-01-09)
========================
### NEW FEATURES
  * Add support for spark plots on Windows

### MAJOR CHANGES
  * `spark_line()` and `spark_bar()` are no longer exported
  * Default statistics for numeric changed from `min(x)` and `max(x)` to 
    `quantile(x, probs = 0)` and `quantile(x, probs = 1)`. These changes
    lead to more predictable behaviors when a column is all NA values.

#### MINOR IMPROVEMENTS
  * Add minimimum required version for stringr
  * Improve documentation in general, especially those related to fonts

### BUG FIXES
  * Fix issue where a histogram for data with all `NA`s threw an error
  * Suppress progress bars from `dplyr::do()`

skimr 0.92 (2017-12-19)
=======================

### MAJOR CHANGES
  * `skim_v()` is no longer exported. Vectors are now directly supported via
    `skim.default()`.
  * Change license to GPL 3

### NEW FEATURES

  * Add support for `kable()` and `pander()` for `skim_df` objects. 
  * Add summary method for `skim_df` objects.  
  * Add support for tidy select to skim specific columns of a data frame.
  * Add support for skimming individual vectors via `skim.default()`. 


skimr 0.91 (2017-10-14)
=========================

### NEW FEATURES

  * Handling of grouped data (generated by `dplyr::group_by()`)
  * Printing for all column classes
  * Add indicator of if a factor is ordered to skim object for factor
  * Introduction of flexible formatting
  * Easy dropping of individual functions
  * Vignettes for basic use and use with specialized object types
  * Updated readme and added CONTRIBUTING.md and CONDUCT.md
  * New public get_skimmers function to access skim functions
  * Support for difftime class
  

### MINOR IMPROVEMENTS

  * Add header to print providing summary information about data.

### BUG FIXES

  * Change from Colformat to Pillar.


skimr 0.900 (2017-07-16)
=========================


### BUG FIXES

  * Fix documentation for get_fun_names()
  * Fix test and build errors and notes

  
