% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplesize_mixed.R
\name{samplesize_mixed}
\alias{samplesize_mixed}
\alias{smpsize_lmm}
\title{Sample size for linear mixed models}
\usage{
samplesize_mixed(
  eff.size,
  df.n = NULL,
  power = 0.8,
  sig.level = 0.05,
  k,
  n,
  icc = 0.05
)

smpsize_lmm(
  eff.size,
  df.n = NULL,
  power = 0.8,
  sig.level = 0.05,
  k,
  n,
  icc = 0.05
)
}
\arguments{
\item{eff.size}{Effect size.}

\item{df.n}{Optional argument for the degrees of freedom for numerator. See 'Details'.}

\item{power}{Power of test (1 minus Type II error probability).}

\item{sig.level}{Significance level (Type I error probability).}

\item{k}{Number of cluster groups (level-2-unit) in multilevel-design.}

\item{n}{Optional, number of observations per cluster groups
(level-2-unit) in multilevel-design.}

\item{icc}{Expected intraclass correlation coefficient for multilevel-model.}
}
\value{
A list with two values: The number of subjects per cluster, and the
          total sample size for the linear mixed model.
}
\description{
Compute an approximated sample size for linear mixed models
               (two-level-designs), based on power-calculation for standard
               design and adjusted for design effect for 2-level-designs.
}
\details{
The sample size calculation is based on a power-calculation for the
         standard design. If \code{df.n} is not specified, a power-calculation
         for an unpaired two-sample t-test will be computed (using
         \code{\link[pwr]{pwr.t.test}} of the \CRANpkg{pwr}-package).
         If \code{df.n} is given, a power-calculation for general linear models
         will be computed (using \code{\link[pwr]{pwr.f2.test}} of the
         \pkg{pwr}-package). The sample size of the standard design
         is then adjusted for the design effect of two-level-designs (see
         \code{\link{design_effect}}). Thus, the sample size calculation is appropriate
         in particular for two-level-designs (see \cite{Snijders 2005}). Models that
         additionally include repeated measures (three-level-designs) may work
         as well, however, the computed sample size may be less accurate.
}
\examples{
# Sample size for multilevel model with 30 cluster groups and a small to
# medium effect size (Cohen's d) of 0.3. 27 subjects per cluster and
# hence a total sample size of about 802 observations is needed.
samplesize_mixed(eff.size = .3, k = 30)

# Sample size for multilevel model with 20 cluster groups and a medium
# to large effect size for linear models of 0.2. Five subjects per cluster and
# hence a total sample size of about 107 observations is needed.
samplesize_mixed(eff.size = .2, df.n = 5, k = 20, power = .9)


}
\references{
Cohen J. 1988. Statistical power analysis for the behavioral sciences (2nd ed.). Hillsdale,NJ: Lawrence Erlbaum.
            \cr \cr
            Hsieh FY, Lavori PW, Cohen HJ, Feussner JR. 2003. An Overview of Variance Inflation Factors for Sample-Size Calculation. Evaluation and the Health Professions 26: 239-257. \doi{10.1177/0163278703255230}
            \cr \cr
            Snijders TAB. 2005. Power and Sample Size in Multilevel Linear Models. In: Everitt BS, Howell DC (Hrsg.). Encyclopedia of Statistics in Behavioral Science. Chichester, UK: John Wiley and Sons, Ltd. \doi{10.1002/0470013192.bsa492}
}
