% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weight.R, R/wtd_ttest.R
\name{wtd_sd}
\alias{wtd_sd}
\alias{wtd_mean}
\alias{wtd_se}
\alias{svy_md}
\alias{wtd_ttest}
\alias{wtd_ttest.default}
\alias{wtd_ttest.formula}
\alias{wtd_mwu}
\alias{wtd_mwu.default}
\alias{wtd_mwu.formula}
\title{Weighted statistics for variables}
\usage{
wtd_sd(x, weights = NULL)

wtd_mean(x, weights = NULL)

wtd_se(x, weights = NULL)

svy_md(x, design)

wtd_ttest(data, ...)

\method{wtd_ttest}{default}(data, x, y = NULL, weights, mu = 0,
  paired = FALSE, ci.lvl = 0.95, alternative = c("two.sided", "less",
  "greater"), ...)

\method{wtd_ttest}{formula}(formula, data, mu = 0, paired = FALSE,
  ci.lvl = 0.95, alternative = c("two.sided", "less", "greater"), ...)

wtd_mwu(data, ...)

\method{wtd_mwu}{default}(data, x, grp, weights, ...)

\method{wtd_mwu}{formula}(formula, data, ...)
}
\arguments{
\item{x}{(Numeric) vector or a data frame. For \code{svy_md()}, \code{wtd_ttest()}
and \code{wtd_mwu()} the bare (unquoted) variable name, or a character
vector with the variable name.}

\item{weights}{Bare (unquoted) variable name, or a character vector with
the variable name of the numeric vector of weights. If \code{weights = NULL},
unweighted statistic is reported.}

\item{design}{An object of class \code{\link[survey]{svydesign}}, providing
a specification of the survey design.}

\item{data}{A data frame.}

\item{...}{Other arguments passed down to \code{\link[MASS]{glm.nb}}.}

\item{y}{Optional, bare (unquoted) variable name, or a character vector with
the variable name.}

\item{mu}{A number indicating the true value of the mean (or difference in
means if you are performing a two sample test).}

\item{paired}{Logical, whether to compute a paired t-test.}

\item{ci.lvl}{Confidence level of the interval.}

\item{alternative}{A character string specifying the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"greater"} or
\code{"less"}. You can specify just the initial letter.}

\item{formula}{A formula of the form \code{lhs ~ rhs1 + rhs2} where \code{lhs} is a
numeric variable giving the data values and \code{rhs1} a factor with two
levels giving the corresponding groups and \code{rhs2} a variable with weights.}

\item{grp}{Bare (unquoted) name of the cross-classifying variable, where
\code{x} is grouped into the categories represented by \code{grp},
or a character vector with the variable name.}
}
\value{
The weighted standard deviation or standard error of \code{x},
          or for each variable if \code{x} is a data frame.
}
\description{
\code{wtd_sd()} and \code{wtd_se()} compute weighted standard
  deviation or standard error for a variable or for all variables of a data
  frame. \code{svy_md()} computes the median for a variable in a survey-design
  (see \code{\link[survey]{svydesign}}). \code{wtd_ttest()} computes a
  weighted t-test, while \code{wtd_mwu()} computes a weighted Mann-Whitney-U
  test or a Kruskal-Wallis test (for more than two groups).
}
\examples{
# weighted sd and se ----

wtd_sd(rnorm(n = 100, mean = 3), runif(n = 100))

data(efc)
wtd_sd(efc[, 1:3], runif(n = nrow(efc)))
wtd_se(efc[, 1:3], runif(n = nrow(efc)))

# svy_md ----

# median for variables from weighted survey designs
library(survey)
data(nhanes_sample)

des <- svydesign(
  id = ~SDMVPSU,
  strat = ~SDMVSTRA,
  weights = ~WTINT2YR,
  nest = TRUE,
  data = nhanes_sample
)

svy_md(total, des)
svy_md("total", des)

# weighted t-test ----

efc$weight <- abs(rnorm(nrow(efc), 1, .3))
wtd_ttest(efc, e17age, weights = weight)
wtd_ttest(efc, e17age, c160age, weights = weight)
wtd_ttest(e17age ~ e16sex + weight, efc)

# weighted mwu-test ----

wtd_mwu(c12hour ~ c161sex + weight, efc)

}
