% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gonadMat-main.R
\name{gonad_mature}
\alias{gonad_mature}
\title{Estimate gonadal maturity}
\usage{
gonad_mature(data, varNames = c("allometric", "stage"), inmName = "inm",
  matName = "mad", method = "fq", niter = 999, seed = 70387)
}
\arguments{
\item{data}{data.frame with allometric variables and stage of sexual maturity (gonad maturation stages).}

\item{varNames}{a character string indicating the name of the allometric 
and the stage of sexual maturity variables to be used for analysis.}

\item{inmName}{a character string indicating the name or names of the inmaturity stage.}

\item{matName}{a character string indicating the name or names of the maturity stage.}

\item{method}{a character string indicating the method to be applied, \code{"fq"} frecuentist GLM, or \code{"bayes"} Bayes GLM (MCMClogit function).}

\item{niter}{number of iterations (bootstrap resampling).}

\item{seed}{a single value, interpreted as an integer.}
}
\value{
An object of class 'gonadMat'.

\code{model} the summary statistics of the model.

\code{A_boot} the 'n iter' values of parameter A.

\code{B_boot} the 'n iter' values of parameter B.

\code{L50} the 'n iter' values of parameter L50 (gonadal size at sexual maturity).

\code{out} a dataframe with the allometric variable "X", stage of sexual maturity, the fitted values for  
logistic regression and confidence intervals (95\%). Also the summary statistics of the model is provided.
}
\description{
Estimate gonadal size at sexual maturity.
}
\details{
Estimate the gonadal size at sexual maturity using a logistic regression with X variable and 
stages of sexual maturity (two categories: inmature and mature). 

The function requires a data.frame with the X (allometric variable) and 
the stage of sexual maturity (gonad maturation stage).

The argument \code{varNames} requires a character string indicating the name of one allometric and the stage
of sexual maturity variable to be used for analysis (e.g \code{varNames = c("total_length", "stage_mat")}). 
So the argument \code{varNames} must contain two character strings only, the first is the allometric variable 
and the second is the stage of sexual maturity.

The arguments \code{inmName} and \code{matName} require a character string indicanting the name 
of the stages of sexual maturity in the data.frame. The argument could contain one character string 
or could be a vector (e.g \code{inmName = "I"}, \code{matName = c("II", "III", "IV")}).

The argument \code{method} requires a character string indicating which regression will be used for the test.
If \code{method = "fq"} the logistic regression is based on GLM (frequentist), if \code{method = "bayes"} a sample from 
the posterior distribution of a logistic regression model using a random walk Metropolis algorithm is generated (see MCMClogit function).

The argument \code{niter} requires a number. For the GLM regression (\code{method = "fq"}), a non-parametric bootstrap method consists
in generate B bootstrap samples, by resampling with replacement the original data. Then all statistics for each parameter 
can be calculated from each bootstrap sample (median and confidence intervals). 
For the \code{method = "bayes"}, the argument \code{niter} is related to the number of Metropolis iterations for the sampler.
}
\examples{
data(matFish)

gonad_mat = gonad_mature(matFish, varNames = c("total_length", "stage_mat"), inmName = "I", 
matName = c("II", "III", "IV"), method = "fq", niter = 50)

## \\eqn{niter} parameters:
gonad_mat$A_boot
gonad_mat$B_boot
gonad_mat$L50_boot
gonad_mat$out
}

