% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMS2z.R
\name{LMS2z}
\alias{LMS2z}
\title{Convert to/from measurement from/to z-score with growth reference}
\usage{
LMS2z(x, y, sex, measure, ref, toz = TRUE, LMStable = FALSE)
}
\arguments{
\item{x}{vector of ages in units of years.}

\item{y}{vector or one-column matrix of either measurements or z-scores,
depending on the value of \code{toz}.}

\item{sex}{vector where 1/2 = males/females = boys/girls = TRUE/FALSE, based
on the uppercased first character of the string.}

\item{measure}{measurement name, as character string, the choice depending on
the choice of \code{ref} (see e.g. references \code{uk90}, \code{who06} and
\code{ukwhopt}).}

\item{ref}{growth reference, either as name or character string, available as
a \code{data} object or data frame (e.g. \code{uk90}, \code{who06} or
\code{ukwhopt}).}

\item{toz}{logical set to TRUE for conversion from measurement to z-score, or
FALSE for the reverse.}

\item{LMStable}{logical set to TRUE to return the associated LMS table as a
data frame in attribute \code{LMStable}.}
}
\value{
A vector or matrix containing the transformed values. If \code{y} is
  a vector then a vector of \code{length(x)} is returned, else if \code{y} is
  a one-column matrix then a matrix is returned, with \code{length(x)} rows
  and \code{length(y)} columns. The matrix row names are set to \code{x}, and
  the column names to either \code{y} or if \code{toz} is FALSE,
  \code{z2cent(y)}. If LMStable is TRUE the associated LMS table is returned
  as a data frame in attribute \code{LMStable}.
}
\description{
A function to convert between measurements and z-scores using a growth
reference previously fitted by the LMS method.
}
\details{
Growth references fitted by the LMS method consist of a table of L, M and S
values by age and sex. Vectors of L, M and S corresponding to \code{x} and
\code{sex} are extracted using cubic interpolation and passed to either
\code{\link{cLMS}} or \code{\link{zLMS}}, depending on \code{toz}.

Disjunct references are supported, where there is a disjunction in the
centiles at a particular age. This may be because the measurement changes,
e.g. from length to height, or because two different references have been
joined together. The disjunction is flagged by including two rows at the
common age, but with different L, M and S values, and measurements at this
age are ascribed to the older reference. For example the \code{who06}
reference has a disjunction at 2 years reflecting the switch from length to
height. As a result height at just below and just above 2 years returns a
different z-score.
}
\examples{

## convert girls' heights data to UK 90 z-scores
data(heights)
data(uk90)
with(heights, LMS2z(age, height, sex = 2, measure = 'ht', ref = 'uk90'))

## construct table of boys' weight centiles by age for WHO standard
data(who06)
zs <- -4:4*2/3 # z-scores for 9 centiles
ages <- 0:20/4 # 3-month ages to 5 years
LMS2z(ages, as.matrix(zs), sex = 'm', measure = 'wt', ref = who06,
  toz = FALSE, LMStable = TRUE)

}
\seealso{
\code{\link{z2cent}}. The LMS method can be fitted to data using the
  package \code{gamlss} with the \code{BCCG} or \code{BCCGo} family, where nu
  (originally lambda), mu and sigma correspond to L, M and S respectively.
}
\author{
Tim Cole \email{tim.cole@ucl.ac.uk}
}
\keyword{arith}
